/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The layout for a widget on a `free` or **new dashboard layout** dashboard.")
@JsonPropertyOrder(value={"height", "is_column_break", "width", "x", "y"})
public class WidgetLayout {
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Long height;
    public static final String JSON_PROPERTY_IS_COLUMN_BREAK = "is_column_break";
    private Boolean isColumnBreak;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Long width;
    public static final String JSON_PROPERTY_X = "x";
    private Long x;
    public static final String JSON_PROPERTY_Y = "y";
    private Long y;

    public WidgetLayout height(Long height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="The height of the widget. Should be a non-negative integer.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getHeight() {
        return this.height;
    }

    public void setHeight(Long height) {
        this.height = height;
    }

    public WidgetLayout isColumnBreak(Boolean isColumnBreak) {
        this.isColumnBreak = isColumnBreak;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the widget should be the first one on the second column in high density or not. **Note**: Only for the **new dashboard layout** and only one widget in the dashboard should have this property set to `true`.")
    @JsonProperty(value="is_column_break")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsColumnBreak() {
        return this.isColumnBreak;
    }

    public void setIsColumnBreak(Boolean isColumnBreak) {
        this.isColumnBreak = isColumnBreak;
    }

    public WidgetLayout width(Long width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="The width of the widget. Should be a non-negative integer.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getWidth() {
        return this.width;
    }

    public void setWidth(Long width) {
        this.width = width;
    }

    public WidgetLayout x(Long x) {
        this.x = x;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="The position of the widget on the x (horizontal) axis. Should be a non-negative integer.")
    @JsonProperty(value="x")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getX() {
        return this.x;
    }

    public void setX(Long x) {
        this.x = x;
    }

    public WidgetLayout y(Long y) {
        this.y = y;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="The position of the widget on the y (vertical) axis. Should be a non-negative integer.")
    @JsonProperty(value="y")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getY() {
        return this.y;
    }

    public void setY(Long y) {
        this.y = y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetLayout widgetLayout = (WidgetLayout)o;
        return Objects.equals(this.height, widgetLayout.height) && Objects.equals(this.isColumnBreak, widgetLayout.isColumnBreak) && Objects.equals(this.width, widgetLayout.width) && Objects.equals(this.x, widgetLayout.x) && Objects.equals(this.y, widgetLayout.y);
    }

    public int hashCode() {
        return Objects.hash(this.height, this.isColumnBreak, this.width, this.x, this.y);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WidgetLayout {\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    isColumnBreak: ").append(this.toIndentedString(this.isColumnBreak)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

