/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Number of Fargate tasks run and hourly usage.")
@JsonPropertyOrder(value={"hour", "tasks_count"})
public class UsageFargateHour {
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_TASKS_COUNT = "tasks_count";
    private Long tasksCount;

    public UsageFargateHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageFargateHour tasksCount(Long tasksCount) {
        this.tasksCount = tasksCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of Fargate tasks run.")
    @JsonProperty(value="tasks_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTasksCount() {
        return this.tasksCount;
    }

    public void setTasksCount(Long tasksCount) {
        this.tasksCount = tasksCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageFargateHour usageFargateHour = (UsageFargateHour)o;
        return Objects.equals(this.hour, usageFargateHour.hour) && Objects.equals(this.tasksCount, usageFargateHour.tasksCount);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.tasksCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageFargateHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    tasksCount: ").append(this.toIndentedString(this.tasksCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

