/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.FormulaAndFunctionQueryDefinition;
import com.datadog.api.v1.client.model.FormulaAndFunctionResponseFormat;
import com.datadog.api.v1.client.model.LogQueryDefinition;
import com.datadog.api.v1.client.model.ProcessQueryDefinition;
import com.datadog.api.v1.client.model.WidgetAggregator;
import com.datadog.api.v1.client.model.WidgetConditionalFormat;
import com.datadog.api.v1.client.model.WidgetFormula;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Updated query value widget.")
@JsonPropertyOrder(value={"aggregator", "apm_query", "conditional_formats", "event_query", "formulas", "log_query", "network_query", "process_query", "profile_metrics_query", "q", "queries", "response_format", "rum_query", "security_query"})
public class QueryValueWidgetRequest {
    public static final String JSON_PROPERTY_AGGREGATOR = "aggregator";
    private WidgetAggregator aggregator;
    public static final String JSON_PROPERTY_APM_QUERY = "apm_query";
    private LogQueryDefinition apmQuery;
    public static final String JSON_PROPERTY_CONDITIONAL_FORMATS = "conditional_formats";
    private List<WidgetConditionalFormat> conditionalFormats = null;
    public static final String JSON_PROPERTY_EVENT_QUERY = "event_query";
    private LogQueryDefinition eventQuery;
    public static final String JSON_PROPERTY_FORMULAS = "formulas";
    private List<WidgetFormula> formulas = null;
    public static final String JSON_PROPERTY_LOG_QUERY = "log_query";
    private LogQueryDefinition logQuery;
    public static final String JSON_PROPERTY_NETWORK_QUERY = "network_query";
    private LogQueryDefinition networkQuery;
    public static final String JSON_PROPERTY_PROCESS_QUERY = "process_query";
    private ProcessQueryDefinition processQuery;
    public static final String JSON_PROPERTY_PROFILE_METRICS_QUERY = "profile_metrics_query";
    private LogQueryDefinition profileMetricsQuery;
    public static final String JSON_PROPERTY_Q = "q";
    private String q;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<FormulaAndFunctionQueryDefinition> queries = null;
    public static final String JSON_PROPERTY_RESPONSE_FORMAT = "response_format";
    private FormulaAndFunctionResponseFormat responseFormat;
    public static final String JSON_PROPERTY_RUM_QUERY = "rum_query";
    private LogQueryDefinition rumQuery;
    public static final String JSON_PROPERTY_SECURITY_QUERY = "security_query";
    private LogQueryDefinition securityQuery;

    public QueryValueWidgetRequest aggregator(WidgetAggregator aggregator) {
        this.aggregator = aggregator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aggregator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetAggregator getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(WidgetAggregator aggregator) {
        this.aggregator = aggregator;
    }

    public QueryValueWidgetRequest apmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="apm_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getApmQuery() {
        return this.apmQuery;
    }

    public void setApmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
    }

    public QueryValueWidgetRequest conditionalFormats(List<WidgetConditionalFormat> conditionalFormats) {
        this.conditionalFormats = conditionalFormats;
        return this;
    }

    public QueryValueWidgetRequest addConditionalFormatsItem(WidgetConditionalFormat conditionalFormatsItem) {
        if (this.conditionalFormats == null) {
            this.conditionalFormats = new ArrayList<WidgetConditionalFormat>();
        }
        this.conditionalFormats.add(conditionalFormatsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of conditional formats.")
    @JsonProperty(value="conditional_formats")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetConditionalFormat> getConditionalFormats() {
        return this.conditionalFormats;
    }

    public void setConditionalFormats(List<WidgetConditionalFormat> conditionalFormats) {
        this.conditionalFormats = conditionalFormats;
    }

    public QueryValueWidgetRequest eventQuery(LogQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="event_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getEventQuery() {
        return this.eventQuery;
    }

    public void setEventQuery(LogQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
    }

    public QueryValueWidgetRequest formulas(List<WidgetFormula> formulas) {
        this.formulas = formulas;
        return this;
    }

    public QueryValueWidgetRequest addFormulasItem(WidgetFormula formulasItem) {
        if (this.formulas == null) {
            this.formulas = new ArrayList<WidgetFormula>();
        }
        this.formulas.add(formulasItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of formulas that operate on queries. **This feature is currently in beta.**")
    @JsonProperty(value="formulas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetFormula> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(List<WidgetFormula> formulas) {
        this.formulas = formulas;
    }

    public QueryValueWidgetRequest logQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="log_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getLogQuery() {
        return this.logQuery;
    }

    public void setLogQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
    }

    public QueryValueWidgetRequest networkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="network_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getNetworkQuery() {
        return this.networkQuery;
    }

    public void setNetworkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
    }

    public QueryValueWidgetRequest processQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="process_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessQueryDefinition getProcessQuery() {
        return this.processQuery;
    }

    public void setProcessQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
    }

    public QueryValueWidgetRequest profileMetricsQuery(LogQueryDefinition profileMetricsQuery) {
        this.profileMetricsQuery = profileMetricsQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profile_metrics_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getProfileMetricsQuery() {
        return this.profileMetricsQuery;
    }

    public void setProfileMetricsQuery(LogQueryDefinition profileMetricsQuery) {
        this.profileMetricsQuery = profileMetricsQuery;
    }

    public QueryValueWidgetRequest q(String q) {
        this.q = q;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TODO.")
    @JsonProperty(value="q")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public QueryValueWidgetRequest queries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
        return this;
    }

    public QueryValueWidgetRequest addQueriesItem(FormulaAndFunctionQueryDefinition queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<FormulaAndFunctionQueryDefinition>();
        }
        this.queries.add(queriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of queries that can be returned directly or used in formulas. **This feature is currently in beta.**")
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FormulaAndFunctionQueryDefinition> getQueries() {
        return this.queries;
    }

    public void setQueries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
    }

    public QueryValueWidgetRequest responseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="response_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormulaAndFunctionResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public QueryValueWidgetRequest rumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="rum_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getRumQuery() {
        return this.rumQuery;
    }

    public void setRumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
    }

    public QueryValueWidgetRequest securityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="security_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getSecurityQuery() {
        return this.securityQuery;
    }

    public void setSecurityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryValueWidgetRequest queryValueWidgetRequest = (QueryValueWidgetRequest)o;
        return Objects.equals((Object)this.aggregator, (Object)queryValueWidgetRequest.aggregator) && Objects.equals(this.apmQuery, queryValueWidgetRequest.apmQuery) && Objects.equals(this.conditionalFormats, queryValueWidgetRequest.conditionalFormats) && Objects.equals(this.eventQuery, queryValueWidgetRequest.eventQuery) && Objects.equals(this.formulas, queryValueWidgetRequest.formulas) && Objects.equals(this.logQuery, queryValueWidgetRequest.logQuery) && Objects.equals(this.networkQuery, queryValueWidgetRequest.networkQuery) && Objects.equals(this.processQuery, queryValueWidgetRequest.processQuery) && Objects.equals(this.profileMetricsQuery, queryValueWidgetRequest.profileMetricsQuery) && Objects.equals(this.q, queryValueWidgetRequest.q) && Objects.equals(this.queries, queryValueWidgetRequest.queries) && Objects.equals((Object)this.responseFormat, (Object)queryValueWidgetRequest.responseFormat) && Objects.equals(this.rumQuery, queryValueWidgetRequest.rumQuery) && Objects.equals(this.securityQuery, queryValueWidgetRequest.securityQuery);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregator, this.apmQuery, this.conditionalFormats, this.eventQuery, this.formulas, this.logQuery, this.networkQuery, this.processQuery, this.profileMetricsQuery, this.q, this.queries, this.responseFormat, this.rumQuery, this.securityQuery});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryValueWidgetRequest {\n");
        sb.append("    aggregator: ").append(this.toIndentedString((Object)this.aggregator)).append("\n");
        sb.append("    apmQuery: ").append(this.toIndentedString(this.apmQuery)).append("\n");
        sb.append("    conditionalFormats: ").append(this.toIndentedString(this.conditionalFormats)).append("\n");
        sb.append("    eventQuery: ").append(this.toIndentedString(this.eventQuery)).append("\n");
        sb.append("    formulas: ").append(this.toIndentedString(this.formulas)).append("\n");
        sb.append("    logQuery: ").append(this.toIndentedString(this.logQuery)).append("\n");
        sb.append("    networkQuery: ").append(this.toIndentedString(this.networkQuery)).append("\n");
        sb.append("    processQuery: ").append(this.toIndentedString(this.processQuery)).append("\n");
        sb.append("    profileMetricsQuery: ").append(this.toIndentedString(this.profileMetricsQuery)).append("\n");
        sb.append("    q: ").append(this.toIndentedString(this.q)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    responseFormat: ").append(this.toIndentedString((Object)this.responseFormat)).append("\n");
        sb.append("    rumQuery: ").append(this.toIndentedString(this.rumQuery)).append("\n");
        sb.append("    securityQuery: ").append(this.toIndentedString(this.securityQuery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

