/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Description of errors.")
@JsonPropertyOrder(value={"code", "message"})
public class AWSLogsAsyncError {
    public static final String JSON_PROPERTY_CODE = "code";
    private String code;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;

    public AWSLogsAsyncError code(String code) {
        this.code = code;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="no_such_config", value="Code properties")
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public AWSLogsAsyncError message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AWS account 12345 has no lambda config to update", value="Message content.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSLogsAsyncError awSLogsAsyncError = (AWSLogsAsyncError)o;
        return Objects.equals(this.code, awSLogsAsyncError.code) && Objects.equals(this.message, awSLogsAsyncError.message);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSLogsAsyncError {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

