/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Used to perform a histogram computation (only for measure facets). Note: At most 100 buckets are allowed, the number of buckets is (max - min)/interval.")
@JsonPropertyOrder(value={"interval", "max", "min"})
public class LogsGroupByHistogram {
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private Double interval;
    public static final String JSON_PROPERTY_MAX = "max";
    private Double max;
    public static final String JSON_PROPERTY_MIN = "min";
    private Double min;

    public LogsGroupByHistogram interval(Double interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="10", required=true, value="The bin size of the histogram buckets")
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getInterval() {
        return this.interval;
    }

    public void setInterval(Double interval) {
        this.interval = interval;
    }

    public LogsGroupByHistogram max(Double max) {
        this.max = max;
        return this;
    }

    @ApiModelProperty(example="100", required=true, value="The maximum value for the measure used in the histogram (values greater than this one are filtered out)")
    @JsonProperty(value="max")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getMax() {
        return this.max;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public LogsGroupByHistogram min(Double min) {
        this.min = min;
        return this;
    }

    @ApiModelProperty(example="50", required=true, value="The minimum value for the measure used in the histogram (values smaller than this one are filtered out)")
    @JsonProperty(value="min")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getMin() {
        return this.min;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsGroupByHistogram logsGroupByHistogram = (LogsGroupByHistogram)o;
        return Objects.equals(this.interval, logsGroupByHistogram.interval) && Objects.equals(this.max, logsGroupByHistogram.max) && Objects.equals(this.min, logsGroupByHistogram.min);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.max, this.min);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsGroupByHistogram {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    max: ").append(this.toIndentedString(this.max)).append("\n");
        sb.append("    min: ").append(this.toIndentedString(this.min)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

