/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.LogsMetricCreateRequest;
import com.datadog.api.v2.client.model.LogsMetricResponse;
import com.datadog.api.v2.client.model.LogsMetricUpdateRequest;
import com.datadog.api.v2.client.model.LogsMetricsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class LogsMetricsApi {
    private ApiClient apiClient;

    public LogsMetricsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogsMetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public LogsMetricResponse createLogsMetric(LogsMetricCreateRequest body) throws ApiException {
        return this.createLogsMetricWithHttpInfo(body).getData();
    }

    public ApiResponse<LogsMetricResponse> createLogsMetricWithHttpInfo(LogsMetricCreateRequest body) throws ApiException {
        LogsMetricCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createLogsMetric");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsMetricResponse> localVarReturnType = new GenericType<LogsMetricResponse>(){};
        return this.apiClient.invokeAPI("LogsMetricsApi.createLogsMetric", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteLogsMetric(String metricId) throws ApiException {
        this.deleteLogsMetricWithHttpInfo(metricId);
    }

    public ApiResponse<Void> deleteLogsMetricWithHttpInfo(String metricId) throws ApiException {
        Object localVarPostBody = null;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling deleteLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteLogsMetric");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("LogsMetricsApi.deleteLogsMetric", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public LogsMetricResponse getLogsMetric(String metricId) throws ApiException {
        return this.getLogsMetricWithHttpInfo(metricId).getData();
    }

    public ApiResponse<LogsMetricResponse> getLogsMetricWithHttpInfo(String metricId) throws ApiException {
        Object localVarPostBody = null;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling getLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getLogsMetric");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsMetricResponse> localVarReturnType = new GenericType<LogsMetricResponse>(){};
        return this.apiClient.invokeAPI("LogsMetricsApi.getLogsMetric", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public LogsMetricsResponse listLogsMetrics() throws ApiException {
        return this.listLogsMetricsWithHttpInfo().getData();
    }

    public ApiResponse<LogsMetricsResponse> listLogsMetricsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLogsMetrics");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsMetricsResponse> localVarReturnType = new GenericType<LogsMetricsResponse>(){};
        return this.apiClient.invokeAPI("LogsMetricsApi.listLogsMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public LogsMetricResponse updateLogsMetric(String metricId, LogsMetricUpdateRequest body) throws ApiException {
        return this.updateLogsMetricWithHttpInfo(metricId, body).getData();
    }

    public ApiResponse<LogsMetricResponse> updateLogsMetricWithHttpInfo(String metricId, LogsMetricUpdateRequest body) throws ApiException {
        LogsMetricUpdateRequest localVarPostBody = body;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling updateLogsMetric");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateLogsMetric");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsMetricResponse> localVarReturnType = new GenericType<LogsMetricResponse>(){};
        return this.apiClient.invokeAPI("LogsMetricsApi.updateLogsMetric", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

