/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Custom links help you connect a data value to a URL, like a Datadog page or your AWS console.")
@JsonPropertyOrder(value={"label", "link"})
public class WidgetCustomLink {
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_LINK = "link";
    private String link;

    public WidgetCustomLink label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(example="Search logs for {{host}}", required=true, value="The label for the custom link URL. Keep the label short and descriptive. Use metrics and tags as variables.")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public WidgetCustomLink link(String link) {
        this.link = link;
        return this;
    }

    @ApiModelProperty(example="https://app.datadoghq.com/logs?query={{host}}", required=true, value="The URL of the custom link. URL must include `http` or `https`. A relative URL must start with `/`.")
    @JsonProperty(value="link")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetCustomLink widgetCustomLink = (WidgetCustomLink)o;
        return Objects.equals(this.label, widgetCustomLink.label) && Objects.equals(this.link, widgetCustomLink.link);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.link);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WidgetCustomLink {\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

