/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsAssertion;
import com.datadog.api.v1.client.model.SyntheticsBrowserVariable;
import com.datadog.api.v1.client.model.SyntheticsConfigVariable;
import com.datadog.api.v1.client.model.SyntheticsTestRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Configuration object for a Synthetic test.")
@JsonPropertyOrder(value={"assertions", "configVariables", "request", "variables"})
public class SyntheticsTestConfig {
    public static final String JSON_PROPERTY_ASSERTIONS = "assertions";
    private List<SyntheticsAssertion> assertions = new ArrayList<SyntheticsAssertion>();
    public static final String JSON_PROPERTY_CONFIG_VARIABLES = "configVariables";
    private List<SyntheticsConfigVariable> configVariables = null;
    public static final String JSON_PROPERTY_REQUEST = "request";
    private SyntheticsTestRequest request;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private List<SyntheticsBrowserVariable> variables = null;

    public SyntheticsTestConfig assertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
        return this;
    }

    public SyntheticsTestConfig addAssertionsItem(SyntheticsAssertion assertionsItem) {
        this.assertions.add(assertionsItem);
        return this;
    }

    @ApiModelProperty(example="[]", required=true, value="Array of assertions used for the test.")
    @JsonProperty(value="assertions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SyntheticsAssertion> getAssertions() {
        return this.assertions;
    }

    public void setAssertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
    }

    public SyntheticsTestConfig configVariables(List<SyntheticsConfigVariable> configVariables) {
        this.configVariables = configVariables;
        return this;
    }

    public SyntheticsTestConfig addConfigVariablesItem(SyntheticsConfigVariable configVariablesItem) {
        if (this.configVariables == null) {
            this.configVariables = new ArrayList<SyntheticsConfigVariable>();
        }
        this.configVariables.add(configVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="API tests only - array of variables used for the test.")
    @JsonProperty(value="configVariables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsConfigVariable> getConfigVariables() {
        return this.configVariables;
    }

    public void setConfigVariables(List<SyntheticsConfigVariable> configVariables) {
        this.configVariables = configVariables;
    }

    public SyntheticsTestConfig request(SyntheticsTestRequest request) {
        this.request = request;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsTestRequest getRequest() {
        return this.request;
    }

    public void setRequest(SyntheticsTestRequest request) {
        this.request = request;
    }

    public SyntheticsTestConfig variables(List<SyntheticsBrowserVariable> variables) {
        this.variables = variables;
        return this;
    }

    public SyntheticsTestConfig addVariablesItem(SyntheticsBrowserVariable variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<SyntheticsBrowserVariable>();
        }
        this.variables.add(variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Browser tests only - array of variables used for the test steps.")
    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsBrowserVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<SyntheticsBrowserVariable> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsTestConfig syntheticsTestConfig = (SyntheticsTestConfig)o;
        return Objects.equals(this.assertions, syntheticsTestConfig.assertions) && Objects.equals(this.configVariables, syntheticsTestConfig.configVariables) && Objects.equals(this.request, syntheticsTestConfig.request) && Objects.equals(this.variables, syntheticsTestConfig.variables);
    }

    public int hashCode() {
        return Objects.hash(this.assertions, this.configVariables, this.request, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsTestConfig {\n");
        sb.append("    assertions: ").append(this.toIndentedString(this.assertions)).append("\n");
        sb.append("    configVariables: ").append(this.toIndentedString(this.configVariables)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

