/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.ServiceMapWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetCustomLink;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="This widget displays a map of a service to all of the services that call it, and all of the services that it calls.")
@JsonPropertyOrder(value={"custom_links", "filters", "service", "title", "title_align", "title_size", "type"})
public class ServiceMapWidgetDefinition {
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_FILTERS = "filters";
    private List<String> filters = new ArrayList<String>();
    public static final String JSON_PROPERTY_SERVICE = "service";
    private String service;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ServiceMapWidgetDefinitionType type = ServiceMapWidgetDefinitionType.SERVICEMAP;

    public ServiceMapWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        return this;
    }

    public ServiceMapWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of custom links.")
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public ServiceMapWidgetDefinition filters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    public ServiceMapWidgetDefinition addFiltersItem(String filtersItem) {
        this.filters.add(filtersItem);
        return this;
    }

    @ApiModelProperty(example="[\"*\"]", required=true, value="Your environment and primary tag (or * if enabled for your account).")
    @JsonProperty(value="filters")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public ServiceMapWidgetDefinition service(String service) {
        this.service = service;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="The ID of the service you want to map.")
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public ServiceMapWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The title of your widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ServiceMapWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    public ServiceMapWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public ServiceMapWidgetDefinition type(ServiceMapWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceMapWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(ServiceMapWidgetDefinitionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceMapWidgetDefinition serviceMapWidgetDefinition = (ServiceMapWidgetDefinition)o;
        return Objects.equals(this.customLinks, serviceMapWidgetDefinition.customLinks) && Objects.equals(this.filters, serviceMapWidgetDefinition.filters) && Objects.equals(this.service, serviceMapWidgetDefinition.service) && Objects.equals(this.title, serviceMapWidgetDefinition.title) && Objects.equals((Object)this.titleAlign, (Object)serviceMapWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, serviceMapWidgetDefinition.titleSize) && Objects.equals((Object)this.type, (Object)serviceMapWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customLinks, this.filters, this.service, this.title, this.titleAlign, this.titleSize, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceMapWidgetDefinition {\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString((Object)this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

