/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.SLOCorrectionCreateRequest;
import com.datadog.api.v1.client.model.SLOCorrectionListResponse;
import com.datadog.api.v1.client.model.SLOCorrectionResponse;
import com.datadog.api.v1.client.model.SLOCorrectionUpdateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class ServiceLevelObjectiveCorrectionsApi {
    private ApiClient apiClient;

    public ServiceLevelObjectiveCorrectionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ServiceLevelObjectiveCorrectionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SLOCorrectionResponse createSLOCorrection(SLOCorrectionCreateRequest body) throws ApiException {
        return this.createSLOCorrectionWithHttpInfo(body).getData();
    }

    public ApiResponse<SLOCorrectionResponse> createSLOCorrectionWithHttpInfo(SLOCorrectionCreateRequest body) throws ApiException {
        SLOCorrectionCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSLOCorrection");
        }
        String localVarPath = "/api/v1/slo/correction";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createSLOCorrection");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOCorrectionResponse> localVarReturnType = new GenericType<SLOCorrectionResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectiveCorrectionsApi.createSLOCorrection", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteSLOCorrection(String sloCorrectionId) throws ApiException {
        this.deleteSLOCorrectionWithHttpInfo(sloCorrectionId);
    }

    public ApiResponse<Void> deleteSLOCorrectionWithHttpInfo(String sloCorrectionId) throws ApiException {
        Object localVarPostBody = null;
        if (sloCorrectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloCorrectionId' when calling deleteSLOCorrection");
        }
        String localVarPath = "/api/v1/slo/correction/{slo_correction_id}".replaceAll("\\{slo_correction_id\\}", this.apiClient.escapeString(sloCorrectionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteSLOCorrection");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("ServiceLevelObjectiveCorrectionsApi.deleteSLOCorrection", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public SLOCorrectionResponse getSLOCorrection(String sloCorrectionId) throws ApiException {
        return this.getSLOCorrectionWithHttpInfo(sloCorrectionId).getData();
    }

    public ApiResponse<SLOCorrectionResponse> getSLOCorrectionWithHttpInfo(String sloCorrectionId) throws ApiException {
        Object localVarPostBody = null;
        if (sloCorrectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloCorrectionId' when calling getSLOCorrection");
        }
        String localVarPath = "/api/v1/slo/correction/{slo_correction_id}".replaceAll("\\{slo_correction_id\\}", this.apiClient.escapeString(sloCorrectionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSLOCorrection");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOCorrectionResponse> localVarReturnType = new GenericType<SLOCorrectionResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectiveCorrectionsApi.getSLOCorrection", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SLOCorrectionListResponse listSLOCorrection() throws ApiException {
        return this.listSLOCorrectionWithHttpInfo().getData();
    }

    public ApiResponse<SLOCorrectionListResponse> listSLOCorrectionWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/slo/correction";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listSLOCorrection");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOCorrectionListResponse> localVarReturnType = new GenericType<SLOCorrectionListResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectiveCorrectionsApi.listSLOCorrection", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SLOCorrectionResponse updateSLOCorrection(String sloCorrectionId, SLOCorrectionUpdateRequest body) throws ApiException {
        return this.updateSLOCorrectionWithHttpInfo(sloCorrectionId, body).getData();
    }

    public ApiResponse<SLOCorrectionResponse> updateSLOCorrectionWithHttpInfo(String sloCorrectionId, SLOCorrectionUpdateRequest body) throws ApiException {
        SLOCorrectionUpdateRequest localVarPostBody = body;
        if (sloCorrectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloCorrectionId' when calling updateSLOCorrection");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSLOCorrection");
        }
        String localVarPath = "/api/v1/slo/correction/{slo_correction_id}".replaceAll("\\{slo_correction_id\\}", this.apiClient.escapeString(sloCorrectionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateSLOCorrection");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOCorrectionResponse> localVarReturnType = new GenericType<SLOCorrectionResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectiveCorrectionsApi.updateSLOCorrection", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

