/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Search filters for listing logs.")
@JsonPropertyOrder(value={"from", "indexes", "query", "to"})
public class LogsListRequestFilter {
    public static final String JSON_PROPERTY_FROM = "from";
    private OffsetDateTime from;
    public static final String JSON_PROPERTY_INDEXES = "indexes";
    private List<String> indexes = null;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_TO = "to";
    private OffsetDateTime to;

    public LogsListRequestFilter from(OffsetDateTime from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-01-02T09:42:36.320Z", value="Minimum timestamp for requested logs.")
    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getFrom() {
        return this.from;
    }

    public void setFrom(OffsetDateTime from) {
        this.from = from;
    }

    public LogsListRequestFilter indexes(List<String> indexes) {
        this.indexes = indexes;
        return this;
    }

    public LogsListRequestFilter addIndexesItem(String indexesItem) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<String>();
        }
        this.indexes.add(indexesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"main\"]", value="For customers with multiple indexes, the indexes to search. Defaults to '*' which means all indexes.")
    @JsonProperty(value="indexes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<String> indexes) {
        this.indexes = indexes;
    }

    public LogsListRequestFilter query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="@datacenter:us @role:db", value="Search query following logs syntax.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public LogsListRequestFilter to(OffsetDateTime to) {
        this.to = to;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-01-03T09:42:36.320Z", value="Maximum timestamp for requested logs.")
    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTo() {
        return this.to;
    }

    public void setTo(OffsetDateTime to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsListRequestFilter logsListRequestFilter = (LogsListRequestFilter)o;
        return Objects.equals(this.from, logsListRequestFilter.from) && Objects.equals(this.indexes, logsListRequestFilter.indexes) && Objects.equals(this.query, logsListRequestFilter.query) && Objects.equals(this.to, logsListRequestFilter.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.indexes, this.query, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsListRequestFilter {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    indexes: ").append(this.toIndentedString(this.indexes)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

