/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The hourly usage of timeseries.")
@JsonPropertyOrder(value={"hour", "num_custom_input_timeseries", "num_custom_output_timeseries", "num_custom_timeseries"})
public class UsageTimeseriesHour {
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_NUM_CUSTOM_INPUT_TIMESERIES = "num_custom_input_timeseries";
    private Long numCustomInputTimeseries;
    public static final String JSON_PROPERTY_NUM_CUSTOM_OUTPUT_TIMESERIES = "num_custom_output_timeseries";
    private Long numCustomOutputTimeseries;
    public static final String JSON_PROPERTY_NUM_CUSTOM_TIMESERIES = "num_custom_timeseries";
    private Long numCustomTimeseries;

    public UsageTimeseriesHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageTimeseriesHour numCustomInputTimeseries(Long numCustomInputTimeseries) {
        this.numCustomInputTimeseries = numCustomInputTimeseries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of custom metrics that are inputs for aggregations (metric configured is custom).")
    @JsonProperty(value="num_custom_input_timeseries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNumCustomInputTimeseries() {
        return this.numCustomInputTimeseries;
    }

    public void setNumCustomInputTimeseries(Long numCustomInputTimeseries) {
        this.numCustomInputTimeseries = numCustomInputTimeseries;
    }

    public UsageTimeseriesHour numCustomOutputTimeseries(Long numCustomOutputTimeseries) {
        this.numCustomOutputTimeseries = numCustomOutputTimeseries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of custom metrics that are outputs for aggregations (metric configured is custom).")
    @JsonProperty(value="num_custom_output_timeseries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNumCustomOutputTimeseries() {
        return this.numCustomOutputTimeseries;
    }

    public void setNumCustomOutputTimeseries(Long numCustomOutputTimeseries) {
        this.numCustomOutputTimeseries = numCustomOutputTimeseries;
    }

    public UsageTimeseriesHour numCustomTimeseries(Long numCustomTimeseries) {
        this.numCustomTimeseries = numCustomTimeseries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of non-aggregation custom metrics.")
    @JsonProperty(value="num_custom_timeseries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNumCustomTimeseries() {
        return this.numCustomTimeseries;
    }

    public void setNumCustomTimeseries(Long numCustomTimeseries) {
        this.numCustomTimeseries = numCustomTimeseries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageTimeseriesHour usageTimeseriesHour = (UsageTimeseriesHour)o;
        return Objects.equals(this.hour, usageTimeseriesHour.hour) && Objects.equals(this.numCustomInputTimeseries, usageTimeseriesHour.numCustomInputTimeseries) && Objects.equals(this.numCustomOutputTimeseries, usageTimeseriesHour.numCustomOutputTimeseries) && Objects.equals(this.numCustomTimeseries, usageTimeseriesHour.numCustomTimeseries);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.numCustomInputTimeseries, this.numCustomOutputTimeseries, this.numCustomTimeseries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageTimeseriesHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    numCustomInputTimeseries: ").append(this.toIndentedString(this.numCustomInputTimeseries)).append("\n");
        sb.append("    numCustomOutputTimeseries: ").append(this.toIndentedString(this.numCustomOutputTimeseries)).append("\n");
        sb.append("    numCustomTimeseries: ").append(this.toIndentedString(this.numCustomTimeseries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

