/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.UsageSummaryDate;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response with hourly report of all data billed by Datadog all organizations.")
@JsonPropertyOrder(value={"agent_host_top99p_sum", "apm_host_top99p_sum", "aws_host_top99p_sum", "aws_lambda_func_count", "aws_lambda_invocations_sum", "azure_host_top99p_sum", "billable_ingested_bytes_agg_sum", "container_avg_sum", "container_hwm_sum", "custom_ts_sum", "end_date", "fargate_tasks_count_avg_sum", "fargate_tasks_count_hwm_sum", "gcp_host_top99p_sum", "indexed_events_count_agg_sum", "infra_host_top99p_sum", "ingested_events_bytes_agg_sum", "last_updated", "netflow_indexed_events_count_agg_sum", "npm_host_top99p_sum", "rum_session_count_agg_sum", "start_date", "synthetics_browser_check_calls_count_agg_sum", "synthetics_check_calls_count_agg_sum", "trace_search_indexed_events_count_agg_sum", "usage"})
public class UsageSummaryResponse {
    public static final String JSON_PROPERTY_AGENT_HOST_TOP99P_SUM = "agent_host_top99p_sum";
    private Long agentHostTop99pSum;
    public static final String JSON_PROPERTY_APM_HOST_TOP99P_SUM = "apm_host_top99p_sum";
    private Long apmHostTop99pSum;
    public static final String JSON_PROPERTY_AWS_HOST_TOP99P_SUM = "aws_host_top99p_sum";
    private Long awsHostTop99pSum;
    public static final String JSON_PROPERTY_AWS_LAMBDA_FUNC_COUNT = "aws_lambda_func_count";
    private Long awsLambdaFuncCount;
    public static final String JSON_PROPERTY_AWS_LAMBDA_INVOCATIONS_SUM = "aws_lambda_invocations_sum";
    private Long awsLambdaInvocationsSum;
    public static final String JSON_PROPERTY_AZURE_HOST_TOP99P_SUM = "azure_host_top99p_sum";
    private Long azureHostTop99pSum;
    public static final String JSON_PROPERTY_BILLABLE_INGESTED_BYTES_AGG_SUM = "billable_ingested_bytes_agg_sum";
    private Long billableIngestedBytesAggSum;
    public static final String JSON_PROPERTY_CONTAINER_AVG_SUM = "container_avg_sum";
    private Long containerAvgSum;
    public static final String JSON_PROPERTY_CONTAINER_HWM_SUM = "container_hwm_sum";
    private Long containerHwmSum;
    public static final String JSON_PROPERTY_CUSTOM_TS_SUM = "custom_ts_sum";
    private Long customTsSum;
    public static final String JSON_PROPERTY_END_DATE = "end_date";
    private OffsetDateTime endDate;
    public static final String JSON_PROPERTY_FARGATE_TASKS_COUNT_AVG_SUM = "fargate_tasks_count_avg_sum";
    private Long fargateTasksCountAvgSum;
    public static final String JSON_PROPERTY_FARGATE_TASKS_COUNT_HWM_SUM = "fargate_tasks_count_hwm_sum";
    private Long fargateTasksCountHwmSum;
    public static final String JSON_PROPERTY_GCP_HOST_TOP99P_SUM = "gcp_host_top99p_sum";
    private Long gcpHostTop99pSum;
    public static final String JSON_PROPERTY_INDEXED_EVENTS_COUNT_AGG_SUM = "indexed_events_count_agg_sum";
    private Long indexedEventsCountAggSum;
    public static final String JSON_PROPERTY_INFRA_HOST_TOP99P_SUM = "infra_host_top99p_sum";
    private Long infraHostTop99pSum;
    public static final String JSON_PROPERTY_INGESTED_EVENTS_BYTES_AGG_SUM = "ingested_events_bytes_agg_sum";
    private Long ingestedEventsBytesAggSum;
    public static final String JSON_PROPERTY_LAST_UPDATED = "last_updated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_NETFLOW_INDEXED_EVENTS_COUNT_AGG_SUM = "netflow_indexed_events_count_agg_sum";
    private Long netflowIndexedEventsCountAggSum;
    public static final String JSON_PROPERTY_NPM_HOST_TOP99P_SUM = "npm_host_top99p_sum";
    private Long npmHostTop99pSum;
    public static final String JSON_PROPERTY_RUM_SESSION_COUNT_AGG_SUM = "rum_session_count_agg_sum";
    private Long rumSessionCountAggSum;
    public static final String JSON_PROPERTY_START_DATE = "start_date";
    private OffsetDateTime startDate;
    public static final String JSON_PROPERTY_SYNTHETICS_BROWSER_CHECK_CALLS_COUNT_AGG_SUM = "synthetics_browser_check_calls_count_agg_sum";
    private Long syntheticsBrowserCheckCallsCountAggSum;
    public static final String JSON_PROPERTY_SYNTHETICS_CHECK_CALLS_COUNT_AGG_SUM = "synthetics_check_calls_count_agg_sum";
    private Long syntheticsCheckCallsCountAggSum;
    public static final String JSON_PROPERTY_TRACE_SEARCH_INDEXED_EVENTS_COUNT_AGG_SUM = "trace_search_indexed_events_count_agg_sum";
    private Long traceSearchIndexedEventsCountAggSum;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private List<UsageSummaryDate> usage = null;

    public UsageSummaryResponse agentHostTop99pSum(Long agentHostTop99pSum) {
        this.agentHostTop99pSum = agentHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all agent hosts over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="agent_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAgentHostTop99pSum() {
        return this.agentHostTop99pSum;
    }

    public void setAgentHostTop99pSum(Long agentHostTop99pSum) {
        this.agentHostTop99pSum = agentHostTop99pSum;
    }

    public UsageSummaryResponse apmHostTop99pSum(Long apmHostTop99pSum) {
        this.apmHostTop99pSum = apmHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct APM hosts over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="apm_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getApmHostTop99pSum() {
        return this.apmHostTop99pSum;
    }

    public void setApmHostTop99pSum(Long apmHostTop99pSum) {
        this.apmHostTop99pSum = apmHostTop99pSum;
    }

    public UsageSummaryResponse awsHostTop99pSum(Long awsHostTop99pSum) {
        this.awsHostTop99pSum = awsHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all AWS hosts over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="aws_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsHostTop99pSum() {
        return this.awsHostTop99pSum;
    }

    public void setAwsHostTop99pSum(Long awsHostTop99pSum) {
        this.awsHostTop99pSum = awsHostTop99pSum;
    }

    public UsageSummaryResponse awsLambdaFuncCount(Long awsLambdaFuncCount) {
        this.awsLambdaFuncCount = awsLambdaFuncCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of the number of functions that executed 1 or more times each hour in the current month(s) for all organizations.")
    @JsonProperty(value="aws_lambda_func_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsLambdaFuncCount() {
        return this.awsLambdaFuncCount;
    }

    public void setAwsLambdaFuncCount(Long awsLambdaFuncCount) {
        this.awsLambdaFuncCount = awsLambdaFuncCount;
    }

    public UsageSummaryResponse awsLambdaInvocationsSum(Long awsLambdaInvocationsSum) {
        this.awsLambdaInvocationsSum = awsLambdaInvocationsSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all AWS Lambda invocations over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="aws_lambda_invocations_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsLambdaInvocationsSum() {
        return this.awsLambdaInvocationsSum;
    }

    public void setAwsLambdaInvocationsSum(Long awsLambdaInvocationsSum) {
        this.awsLambdaInvocationsSum = awsLambdaInvocationsSum;
    }

    public UsageSummaryResponse azureHostTop99pSum(Long azureHostTop99pSum) {
        this.azureHostTop99pSum = azureHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all Azure hosts over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="azure_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAzureHostTop99pSum() {
        return this.azureHostTop99pSum;
    }

    public void setAzureHostTop99pSum(Long azureHostTop99pSum) {
        this.azureHostTop99pSum = azureHostTop99pSum;
    }

    public UsageSummaryResponse billableIngestedBytesAggSum(Long billableIngestedBytesAggSum) {
        this.billableIngestedBytesAggSum = billableIngestedBytesAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log bytes ingested over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="billable_ingested_bytes_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getBillableIngestedBytesAggSum() {
        return this.billableIngestedBytesAggSum;
    }

    public void setBillableIngestedBytesAggSum(Long billableIngestedBytesAggSum) {
        this.billableIngestedBytesAggSum = billableIngestedBytesAggSum;
    }

    public UsageSummaryResponse containerAvgSum(Long containerAvgSum) {
        this.containerAvgSum = containerAvgSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of all distinct containers over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="container_avg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContainerAvgSum() {
        return this.containerAvgSum;
    }

    public void setContainerAvgSum(Long containerAvgSum) {
        this.containerAvgSum = containerAvgSum;
    }

    public UsageSummaryResponse containerHwmSum(Long containerHwmSum) {
        this.containerHwmSum = containerHwmSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the high watermark of all distinct containers over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="container_hwm_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContainerHwmSum() {
        return this.containerHwmSum;
    }

    public void setContainerHwmSum(Long containerHwmSum) {
        this.containerHwmSum = containerHwmSum;
    }

    public UsageSummaryResponse customTsSum(Long customTsSum) {
        this.customTsSum = customTsSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average number of distinct custom metrics over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="custom_ts_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCustomTsSum() {
        return this.customTsSum;
    }

    public void setCustomTsSum(Long customTsSum) {
        this.customTsSum = customTsSum;
    }

    public UsageSummaryResponse endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the last date of usage in the current month(s) for all organizations.")
    @JsonProperty(value="end_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public UsageSummaryResponse fargateTasksCountAvgSum(Long fargateTasksCountAvgSum) {
        this.fargateTasksCountAvgSum = fargateTasksCountAvgSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of all Fargate tasks over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="fargate_tasks_count_avg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFargateTasksCountAvgSum() {
        return this.fargateTasksCountAvgSum;
    }

    public void setFargateTasksCountAvgSum(Long fargateTasksCountAvgSum) {
        this.fargateTasksCountAvgSum = fargateTasksCountAvgSum;
    }

    public UsageSummaryResponse fargateTasksCountHwmSum(Long fargateTasksCountHwmSum) {
        this.fargateTasksCountHwmSum = fargateTasksCountHwmSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the high watermark of all Fargate tasks over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="fargate_tasks_count_hwm_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFargateTasksCountHwmSum() {
        return this.fargateTasksCountHwmSum;
    }

    public void setFargateTasksCountHwmSum(Long fargateTasksCountHwmSum) {
        this.fargateTasksCountHwmSum = fargateTasksCountHwmSum;
    }

    public UsageSummaryResponse gcpHostTop99pSum(Long gcpHostTop99pSum) {
        this.gcpHostTop99pSum = gcpHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all GCP hosts over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="gcp_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getGcpHostTop99pSum() {
        return this.gcpHostTop99pSum;
    }

    public void setGcpHostTop99pSum(Long gcpHostTop99pSum) {
        this.gcpHostTop99pSum = gcpHostTop99pSum;
    }

    public UsageSummaryResponse indexedEventsCountAggSum(Long indexedEventsCountAggSum) {
        this.indexedEventsCountAggSum = indexedEventsCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log events indexed over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="indexed_events_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIndexedEventsCountAggSum() {
        return this.indexedEventsCountAggSum;
    }

    public void setIndexedEventsCountAggSum(Long indexedEventsCountAggSum) {
        this.indexedEventsCountAggSum = indexedEventsCountAggSum;
    }

    public UsageSummaryResponse infraHostTop99pSum(Long infraHostTop99pSum) {
        this.infraHostTop99pSum = infraHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct infrastructure hosts over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="infra_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getInfraHostTop99pSum() {
        return this.infraHostTop99pSum;
    }

    public void setInfraHostTop99pSum(Long infraHostTop99pSum) {
        this.infraHostTop99pSum = infraHostTop99pSum;
    }

    public UsageSummaryResponse ingestedEventsBytesAggSum(Long ingestedEventsBytesAggSum) {
        this.ingestedEventsBytesAggSum = ingestedEventsBytesAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log bytes ingested over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="ingested_events_bytes_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIngestedEventsBytesAggSum() {
        return this.ingestedEventsBytesAggSum;
    }

    public void setIngestedEventsBytesAggSum(Long ingestedEventsBytesAggSum) {
        this.ingestedEventsBytesAggSum = ingestedEventsBytesAggSum;
    }

    public UsageSummaryResponse lastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the the most recent hour in the current month(s) for all organizations for which all usages were calculated.")
    @JsonProperty(value="last_updated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public UsageSummaryResponse netflowIndexedEventsCountAggSum(Long netflowIndexedEventsCountAggSum) {
        this.netflowIndexedEventsCountAggSum = netflowIndexedEventsCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Network flows indexed over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="netflow_indexed_events_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNetflowIndexedEventsCountAggSum() {
        return this.netflowIndexedEventsCountAggSum;
    }

    public void setNetflowIndexedEventsCountAggSum(Long netflowIndexedEventsCountAggSum) {
        this.netflowIndexedEventsCountAggSum = netflowIndexedEventsCountAggSum;
    }

    public UsageSummaryResponse npmHostTop99pSum(Long npmHostTop99pSum) {
        this.npmHostTop99pSum = npmHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct Networks hosts over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="npm_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNpmHostTop99pSum() {
        return this.npmHostTop99pSum;
    }

    public void setNpmHostTop99pSum(Long npmHostTop99pSum) {
        this.npmHostTop99pSum = npmHostTop99pSum;
    }

    public UsageSummaryResponse rumSessionCountAggSum(Long rumSessionCountAggSum) {
        this.rumSessionCountAggSum = rumSessionCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all RUM Sessions over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="rum_session_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRumSessionCountAggSum() {
        return this.rumSessionCountAggSum;
    }

    public void setRumSessionCountAggSum(Long rumSessionCountAggSum) {
        this.rumSessionCountAggSum = rumSessionCountAggSum;
    }

    public UsageSummaryResponse startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the first date of usage in the current month(s) for all organizations.")
    @JsonProperty(value="start_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public UsageSummaryResponse syntheticsBrowserCheckCallsCountAggSum(Long syntheticsBrowserCheckCallsCountAggSum) {
        this.syntheticsBrowserCheckCallsCountAggSum = syntheticsBrowserCheckCallsCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Synthetic browser tests over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="synthetics_browser_check_calls_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSyntheticsBrowserCheckCallsCountAggSum() {
        return this.syntheticsBrowserCheckCallsCountAggSum;
    }

    public void setSyntheticsBrowserCheckCallsCountAggSum(Long syntheticsBrowserCheckCallsCountAggSum) {
        this.syntheticsBrowserCheckCallsCountAggSum = syntheticsBrowserCheckCallsCountAggSum;
    }

    public UsageSummaryResponse syntheticsCheckCallsCountAggSum(Long syntheticsCheckCallsCountAggSum) {
        this.syntheticsCheckCallsCountAggSum = syntheticsCheckCallsCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Synthetic API tests over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="synthetics_check_calls_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSyntheticsCheckCallsCountAggSum() {
        return this.syntheticsCheckCallsCountAggSum;
    }

    public void setSyntheticsCheckCallsCountAggSum(Long syntheticsCheckCallsCountAggSum) {
        this.syntheticsCheckCallsCountAggSum = syntheticsCheckCallsCountAggSum;
    }

    public UsageSummaryResponse traceSearchIndexedEventsCountAggSum(Long traceSearchIndexedEventsCountAggSum) {
        this.traceSearchIndexedEventsCountAggSum = traceSearchIndexedEventsCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all analyzed spans indexed over all hours in the current month(s) for all organizations.")
    @JsonProperty(value="trace_search_indexed_events_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTraceSearchIndexedEventsCountAggSum() {
        return this.traceSearchIndexedEventsCountAggSum;
    }

    public void setTraceSearchIndexedEventsCountAggSum(Long traceSearchIndexedEventsCountAggSum) {
        this.traceSearchIndexedEventsCountAggSum = traceSearchIndexedEventsCountAggSum;
    }

    public UsageSummaryResponse usage(List<UsageSummaryDate> usage) {
        this.usage = usage;
        return this;
    }

    public UsageSummaryResponse addUsageItem(UsageSummaryDate usageItem) {
        if (this.usage == null) {
            this.usage = new ArrayList<UsageSummaryDate>();
        }
        this.usage.add(usageItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of objects regarding hourly usage.")
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UsageSummaryDate> getUsage() {
        return this.usage;
    }

    public void setUsage(List<UsageSummaryDate> usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageSummaryResponse usageSummaryResponse = (UsageSummaryResponse)o;
        return Objects.equals(this.agentHostTop99pSum, usageSummaryResponse.agentHostTop99pSum) && Objects.equals(this.apmHostTop99pSum, usageSummaryResponse.apmHostTop99pSum) && Objects.equals(this.awsHostTop99pSum, usageSummaryResponse.awsHostTop99pSum) && Objects.equals(this.awsLambdaFuncCount, usageSummaryResponse.awsLambdaFuncCount) && Objects.equals(this.awsLambdaInvocationsSum, usageSummaryResponse.awsLambdaInvocationsSum) && Objects.equals(this.azureHostTop99pSum, usageSummaryResponse.azureHostTop99pSum) && Objects.equals(this.billableIngestedBytesAggSum, usageSummaryResponse.billableIngestedBytesAggSum) && Objects.equals(this.containerAvgSum, usageSummaryResponse.containerAvgSum) && Objects.equals(this.containerHwmSum, usageSummaryResponse.containerHwmSum) && Objects.equals(this.customTsSum, usageSummaryResponse.customTsSum) && Objects.equals(this.endDate, usageSummaryResponse.endDate) && Objects.equals(this.fargateTasksCountAvgSum, usageSummaryResponse.fargateTasksCountAvgSum) && Objects.equals(this.fargateTasksCountHwmSum, usageSummaryResponse.fargateTasksCountHwmSum) && Objects.equals(this.gcpHostTop99pSum, usageSummaryResponse.gcpHostTop99pSum) && Objects.equals(this.indexedEventsCountAggSum, usageSummaryResponse.indexedEventsCountAggSum) && Objects.equals(this.infraHostTop99pSum, usageSummaryResponse.infraHostTop99pSum) && Objects.equals(this.ingestedEventsBytesAggSum, usageSummaryResponse.ingestedEventsBytesAggSum) && Objects.equals(this.lastUpdated, usageSummaryResponse.lastUpdated) && Objects.equals(this.netflowIndexedEventsCountAggSum, usageSummaryResponse.netflowIndexedEventsCountAggSum) && Objects.equals(this.npmHostTop99pSum, usageSummaryResponse.npmHostTop99pSum) && Objects.equals(this.rumSessionCountAggSum, usageSummaryResponse.rumSessionCountAggSum) && Objects.equals(this.startDate, usageSummaryResponse.startDate) && Objects.equals(this.syntheticsBrowserCheckCallsCountAggSum, usageSummaryResponse.syntheticsBrowserCheckCallsCountAggSum) && Objects.equals(this.syntheticsCheckCallsCountAggSum, usageSummaryResponse.syntheticsCheckCallsCountAggSum) && Objects.equals(this.traceSearchIndexedEventsCountAggSum, usageSummaryResponse.traceSearchIndexedEventsCountAggSum) && Objects.equals(this.usage, usageSummaryResponse.usage);
    }

    public int hashCode() {
        return Objects.hash(this.agentHostTop99pSum, this.apmHostTop99pSum, this.awsHostTop99pSum, this.awsLambdaFuncCount, this.awsLambdaInvocationsSum, this.azureHostTop99pSum, this.billableIngestedBytesAggSum, this.containerAvgSum, this.containerHwmSum, this.customTsSum, this.endDate, this.fargateTasksCountAvgSum, this.fargateTasksCountHwmSum, this.gcpHostTop99pSum, this.indexedEventsCountAggSum, this.infraHostTop99pSum, this.ingestedEventsBytesAggSum, this.lastUpdated, this.netflowIndexedEventsCountAggSum, this.npmHostTop99pSum, this.rumSessionCountAggSum, this.startDate, this.syntheticsBrowserCheckCallsCountAggSum, this.syntheticsCheckCallsCountAggSum, this.traceSearchIndexedEventsCountAggSum, this.usage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageSummaryResponse {\n");
        sb.append("    agentHostTop99pSum: ").append(this.toIndentedString(this.agentHostTop99pSum)).append("\n");
        sb.append("    apmHostTop99pSum: ").append(this.toIndentedString(this.apmHostTop99pSum)).append("\n");
        sb.append("    awsHostTop99pSum: ").append(this.toIndentedString(this.awsHostTop99pSum)).append("\n");
        sb.append("    awsLambdaFuncCount: ").append(this.toIndentedString(this.awsLambdaFuncCount)).append("\n");
        sb.append("    awsLambdaInvocationsSum: ").append(this.toIndentedString(this.awsLambdaInvocationsSum)).append("\n");
        sb.append("    azureHostTop99pSum: ").append(this.toIndentedString(this.azureHostTop99pSum)).append("\n");
        sb.append("    billableIngestedBytesAggSum: ").append(this.toIndentedString(this.billableIngestedBytesAggSum)).append("\n");
        sb.append("    containerAvgSum: ").append(this.toIndentedString(this.containerAvgSum)).append("\n");
        sb.append("    containerHwmSum: ").append(this.toIndentedString(this.containerHwmSum)).append("\n");
        sb.append("    customTsSum: ").append(this.toIndentedString(this.customTsSum)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    fargateTasksCountAvgSum: ").append(this.toIndentedString(this.fargateTasksCountAvgSum)).append("\n");
        sb.append("    fargateTasksCountHwmSum: ").append(this.toIndentedString(this.fargateTasksCountHwmSum)).append("\n");
        sb.append("    gcpHostTop99pSum: ").append(this.toIndentedString(this.gcpHostTop99pSum)).append("\n");
        sb.append("    indexedEventsCountAggSum: ").append(this.toIndentedString(this.indexedEventsCountAggSum)).append("\n");
        sb.append("    infraHostTop99pSum: ").append(this.toIndentedString(this.infraHostTop99pSum)).append("\n");
        sb.append("    ingestedEventsBytesAggSum: ").append(this.toIndentedString(this.ingestedEventsBytesAggSum)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    netflowIndexedEventsCountAggSum: ").append(this.toIndentedString(this.netflowIndexedEventsCountAggSum)).append("\n");
        sb.append("    npmHostTop99pSum: ").append(this.toIndentedString(this.npmHostTop99pSum)).append("\n");
        sb.append("    rumSessionCountAggSum: ").append(this.toIndentedString(this.rumSessionCountAggSum)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    syntheticsBrowserCheckCallsCountAggSum: ").append(this.toIndentedString(this.syntheticsBrowserCheckCallsCountAggSum)).append("\n");
        sb.append("    syntheticsCheckCallsCountAggSum: ").append(this.toIndentedString(this.syntheticsCheckCallsCountAggSum)).append("\n");
        sb.append("    traceSearchIndexedEventsCountAggSum: ").append(this.toIndentedString(this.traceSearchIndexedEventsCountAggSum)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

