/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SLOHistoryMetrics;
import com.datadog.api.v1.client.model.SLOHistorySLIData;
import com.datadog.api.v1.client.model.SLOThreshold;
import com.datadog.api.v1.client.model.SLOType;
import com.datadog.api.v1.client.model.SLOTypeNumeric;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An array of service level objective objects.")
@JsonPropertyOrder(value={"from_ts", "groups", "overall", "series", "thresholds", "to_ts", "type", "type_id"})
public class SLOHistoryResponseData {
    public static final String JSON_PROPERTY_FROM_TS = "from_ts";
    private Long fromTs;
    public static final String JSON_PROPERTY_GROUPS = "groups";
    private SLOHistorySLIData groups;
    public static final String JSON_PROPERTY_OVERALL = "overall";
    private SLOHistorySLIData overall;
    public static final String JSON_PROPERTY_SERIES = "series";
    private SLOHistoryMetrics series;
    public static final String JSON_PROPERTY_THRESHOLDS = "thresholds";
    private Map<String, SLOThreshold> thresholds = null;
    public static final String JSON_PROPERTY_TO_TS = "to_ts";
    private Long toTs;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SLOType type;
    public static final String JSON_PROPERTY_TYPE_ID = "type_id";
    private SLOTypeNumeric typeId;

    public SLOHistoryResponseData fromTs(Long fromTs) {
        this.fromTs = fromTs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `from` timestamp in epoch seconds.")
    @JsonProperty(value="from_ts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFromTs() {
        return this.fromTs;
    }

    public void setFromTs(Long fromTs) {
        this.fromTs = fromTs;
    }

    public SLOHistoryResponseData groups(SLOHistorySLIData groups) {
        this.groups = groups;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOHistorySLIData getGroups() {
        return this.groups;
    }

    public void setGroups(SLOHistorySLIData groups) {
        this.groups = groups;
    }

    public SLOHistoryResponseData overall(SLOHistorySLIData overall) {
        this.overall = overall;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="overall")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOHistorySLIData getOverall() {
        return this.overall;
    }

    public void setOverall(SLOHistorySLIData overall) {
        this.overall = overall;
    }

    public SLOHistoryResponseData series(SLOHistoryMetrics series) {
        this.series = series;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="series")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOHistoryMetrics getSeries() {
        return this.series;
    }

    public void setSeries(SLOHistoryMetrics series) {
        this.series = series;
    }

    public SLOHistoryResponseData thresholds(Map<String, SLOThreshold> thresholds) {
        this.thresholds = thresholds;
        return this;
    }

    public SLOHistoryResponseData putThresholdsItem(String key, SLOThreshold thresholdsItem) {
        if (this.thresholds == null) {
            this.thresholds = new HashMap<String, SLOThreshold>();
        }
        this.thresholds.put(key, thresholdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="mapping of string timeframe to the SLO threshold.")
    @JsonProperty(value="thresholds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, SLOThreshold> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Map<String, SLOThreshold> thresholds) {
        this.thresholds = thresholds;
    }

    public SLOHistoryResponseData toTs(Long toTs) {
        this.toTs = toTs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `to` timestamp in epoch seconds.")
    @JsonProperty(value="to_ts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getToTs() {
        return this.toTs;
    }

    public void setToTs(Long toTs) {
        this.toTs = toTs;
    }

    public SLOHistoryResponseData type(SLOType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOType getType() {
        return this.type;
    }

    public void setType(SLOType type) {
        this.type = type;
    }

    public SLOHistoryResponseData typeId(SLOTypeNumeric typeId) {
        this.typeId = typeId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOTypeNumeric getTypeId() {
        return this.typeId;
    }

    public void setTypeId(SLOTypeNumeric typeId) {
        this.typeId = typeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistoryResponseData slOHistoryResponseData = (SLOHistoryResponseData)o;
        return Objects.equals(this.fromTs, slOHistoryResponseData.fromTs) && Objects.equals(this.groups, slOHistoryResponseData.groups) && Objects.equals(this.overall, slOHistoryResponseData.overall) && Objects.equals(this.series, slOHistoryResponseData.series) && Objects.equals(this.thresholds, slOHistoryResponseData.thresholds) && Objects.equals(this.toTs, slOHistoryResponseData.toTs) && Objects.equals((Object)this.type, (Object)slOHistoryResponseData.type) && Objects.equals((Object)this.typeId, (Object)slOHistoryResponseData.typeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fromTs, this.groups, this.overall, this.series, this.thresholds, this.toTs, this.type, this.typeId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistoryResponseData {\n");
        sb.append("    fromTs: ").append(this.toIndentedString(this.fromTs)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    overall: ").append(this.toIndentedString(this.overall)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    thresholds: ").append(this.toIndentedString(this.thresholds)).append("\n");
        sb.append("    toTs: ").append(this.toIndentedString(this.toTs)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    typeId: ").append(this.toIndentedString((Object)this.typeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

