/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.WidgetSort;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Define a sorting method.")
@JsonPropertyOrder(value={"aggregation", "facet", "order"})
public class LogQueryDefinitionSort {
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private String aggregation;
    public static final String JSON_PROPERTY_FACET = "facet";
    private String facet;
    public static final String JSON_PROPERTY_ORDER = "order";
    private WidgetSort order;

    public LogQueryDefinitionSort aggregation(String aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    @ApiModelProperty(example="avg", required=true, value="The aggregation method.")
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    public LogQueryDefinitionSort facet(String facet) {
        this.facet = facet;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="@string_query.interval", value="Facet name.")
    @JsonProperty(value="facet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFacet() {
        return this.facet;
    }

    public void setFacet(String facet) {
        this.facet = facet;
    }

    public LogQueryDefinitionSort order(WidgetSort order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetSort getOrder() {
        return this.order;
    }

    public void setOrder(WidgetSort order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogQueryDefinitionSort logQueryDefinitionSort = (LogQueryDefinitionSort)o;
        return Objects.equals(this.aggregation, logQueryDefinitionSort.aggregation) && Objects.equals(this.facet, logQueryDefinitionSort.facet) && Objects.equals((Object)this.order, (Object)logQueryDefinitionSort.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregation, this.facet, this.order});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogQueryDefinitionSort {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    facet: ").append(this.toIndentedString(this.facet)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

