/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.ImageWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetImageSizing;
import com.datadog.api.v1.client.model.WidgetMargin;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The image widget allows you to embed an image on your dashboard. An image can be a PNG, JPG, or animated GIF. Only available on FREE layout dashboards.")
@JsonPropertyOrder(value={"margin", "sizing", "type", "url"})
public class ImageWidgetDefinition {
    public static final String JSON_PROPERTY_MARGIN = "margin";
    private WidgetMargin margin;
    public static final String JSON_PROPERTY_SIZING = "sizing";
    private WidgetImageSizing sizing;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ImageWidgetDefinitionType type = ImageWidgetDefinitionType.IMAGE;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public ImageWidgetDefinition margin(WidgetMargin margin) {
        this.margin = margin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="margin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetMargin getMargin() {
        return this.margin;
    }

    public void setMargin(WidgetMargin margin) {
        this.margin = margin;
    }

    public ImageWidgetDefinition sizing(WidgetImageSizing sizing) {
        this.sizing = sizing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="sizing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetImageSizing getSizing() {
        return this.sizing;
    }

    public void setSizing(WidgetImageSizing sizing) {
        this.sizing = sizing;
    }

    public ImageWidgetDefinition type(ImageWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ImageWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(ImageWidgetDefinitionType type) {
        this.type = type;
    }

    public ImageWidgetDefinition url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(required=true, value="URL of the image.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageWidgetDefinition imageWidgetDefinition = (ImageWidgetDefinition)o;
        return Objects.equals((Object)this.margin, (Object)imageWidgetDefinition.margin) && Objects.equals((Object)this.sizing, (Object)imageWidgetDefinition.sizing) && Objects.equals((Object)this.type, (Object)imageWidgetDefinition.type) && Objects.equals(this.url, imageWidgetDefinition.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.margin, this.sizing, this.type, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageWidgetDefinition {\n");
        sb.append("    margin: ").append(this.toIndentedString((Object)this.margin)).append("\n");
        sb.append("    sizing: ").append(this.toIndentedString((Object)this.sizing)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

