/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.CheckCanDeleteSLOResponse;
import com.datadog.api.v1.client.model.SLOBulkDeleteResponse;
import com.datadog.api.v1.client.model.SLODeleteResponse;
import com.datadog.api.v1.client.model.SLOHistoryResponse;
import com.datadog.api.v1.client.model.SLOListResponse;
import com.datadog.api.v1.client.model.SLOResponse;
import com.datadog.api.v1.client.model.SLOTimeframe;
import com.datadog.api.v1.client.model.ServiceLevelObjective;
import com.datadog.api.v1.client.model.ServiceLevelObjectiveRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class ServiceLevelObjectivesApi {
    private ApiClient apiClient;

    public ServiceLevelObjectivesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ServiceLevelObjectivesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<CheckCanDeleteSLOResponse> checkCanDeleteSLOWithHttpInfo(String ids) throws ApiException {
        Object localVarPostBody = null;
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling checkCanDeleteSLO");
        }
        String localVarPath = "/api/v1/slo/can_delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ids", ids));
        localVarHeaderParams.put("DD-OPERATION-ID", "checkCanDeleteSLO");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<CheckCanDeleteSLOResponse> localVarReturnType = new GenericType<CheckCanDeleteSLOResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.checkCanDeleteSLO", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcheckCanDeleteSLORequest checkCanDeleteSLO() throws ApiException {
        return new APIcheckCanDeleteSLORequest();
    }

    private ApiResponse<SLOListResponse> createSLOWithHttpInfo(ServiceLevelObjectiveRequest body) throws ApiException {
        ServiceLevelObjectiveRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSLO");
        }
        String localVarPath = "/api/v1/slo";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createSLO");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOListResponse> localVarReturnType = new GenericType<SLOListResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.createSLO", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcreateSLORequest createSLO() throws ApiException {
        return new APIcreateSLORequest();
    }

    private ApiResponse<SLODeleteResponse> deleteSLOWithHttpInfo(String sloId, String force) throws ApiException {
        Object localVarPostBody = null;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling deleteSLO");
        }
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "force", force));
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteSLO");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLODeleteResponse> localVarReturnType = new GenericType<SLODeleteResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.deleteSLO", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIdeleteSLORequest deleteSLO(String sloId) throws ApiException {
        return new APIdeleteSLORequest(sloId);
    }

    private ApiResponse<SLOBulkDeleteResponse> deleteSLOTimeframeInBulkWithHttpInfo(Map<String, List<SLOTimeframe>> body) throws ApiException {
        Map<String, List<SLOTimeframe>> localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteSLOTimeframeInBulk");
        }
        String localVarPath = "/api/v1/slo/bulk_delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteSLOTimeframeInBulk");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOBulkDeleteResponse> localVarReturnType = new GenericType<SLOBulkDeleteResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.deleteSLOTimeframeInBulk", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIdeleteSLOTimeframeInBulkRequest deleteSLOTimeframeInBulk() throws ApiException {
        return new APIdeleteSLOTimeframeInBulkRequest();
    }

    private ApiResponse<SLOResponse> getSLOWithHttpInfo(String sloId) throws ApiException {
        Object localVarPostBody = null;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling getSLO");
        }
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSLO");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOResponse> localVarReturnType = new GenericType<SLOResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.getSLO", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetSLORequest getSLO(String sloId) throws ApiException {
        return new APIgetSLORequest(sloId);
    }

    private ApiResponse<SLOHistoryResponse> getSLOHistoryWithHttpInfo(String sloId, Long fromTs, Long toTs) throws ApiException {
        Object localVarPostBody = null;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling getSLOHistory");
        }
        if (fromTs == null) {
            throw new ApiException(400, "Missing the required parameter 'fromTs' when calling getSLOHistory");
        }
        if (toTs == null) {
            throw new ApiException(400, "Missing the required parameter 'toTs' when calling getSLOHistory");
        }
        String localVarPath = "/api/v1/slo/{slo_id}/history".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarHeaderParams.put("DD-OPERATION-ID", "getSLOHistory");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOHistoryResponse> localVarReturnType = new GenericType<SLOHistoryResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.getSLOHistory", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetSLOHistoryRequest getSLOHistory(String sloId) throws ApiException {
        String operationId = "getSLOHistory";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIgetSLOHistoryRequest(sloId);
    }

    private ApiResponse<SLOListResponse> listSLOsWithHttpInfo(String ids) throws ApiException {
        Object localVarPostBody = null;
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling listSLOs");
        }
        String localVarPath = "/api/v1/slo";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ids", ids));
        localVarHeaderParams.put("DD-OPERATION-ID", "listSLOs");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOListResponse> localVarReturnType = new GenericType<SLOListResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.listSLOs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistSLOsRequest listSLOs() throws ApiException {
        return new APIlistSLOsRequest();
    }

    private ApiResponse<SLOListResponse> updateSLOWithHttpInfo(String sloId, ServiceLevelObjective body) throws ApiException {
        ServiceLevelObjective localVarPostBody = body;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling updateSLO");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSLO");
        }
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateSLO");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOListResponse> localVarReturnType = new GenericType<SLOListResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.updateSLO", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIupdateSLORequest updateSLO(String sloId) throws ApiException {
        return new APIupdateSLORequest(sloId);
    }

    public class APIupdateSLORequest {
        private String sloId;
        private ServiceLevelObjective body;

        private APIupdateSLORequest(String sloId) {
            this.sloId = sloId;
        }

        public APIupdateSLORequest body(ServiceLevelObjective body) {
            this.body = body;
            return this;
        }

        public SLOListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SLOListResponse> executeWithHttpInfo() throws ApiException {
            return ServiceLevelObjectivesApi.this.updateSLOWithHttpInfo(this.sloId, this.body);
        }
    }

    public class APIlistSLOsRequest {
        private String ids;

        private APIlistSLOsRequest() {
        }

        public APIlistSLOsRequest ids(String ids) {
            this.ids = ids;
            return this;
        }

        public SLOListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SLOListResponse> executeWithHttpInfo() throws ApiException {
            return ServiceLevelObjectivesApi.this.listSLOsWithHttpInfo(this.ids);
        }
    }

    public class APIgetSLOHistoryRequest {
        private String sloId;
        private Long fromTs;
        private Long toTs;

        private APIgetSLOHistoryRequest(String sloId) {
            this.sloId = sloId;
        }

        public APIgetSLOHistoryRequest fromTs(Long fromTs) {
            this.fromTs = fromTs;
            return this;
        }

        public APIgetSLOHistoryRequest toTs(Long toTs) {
            this.toTs = toTs;
            return this;
        }

        public SLOHistoryResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SLOHistoryResponse> executeWithHttpInfo() throws ApiException {
            return ServiceLevelObjectivesApi.this.getSLOHistoryWithHttpInfo(this.sloId, this.fromTs, this.toTs);
        }
    }

    public class APIgetSLORequest {
        private String sloId;

        private APIgetSLORequest(String sloId) {
            this.sloId = sloId;
        }

        public SLOResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SLOResponse> executeWithHttpInfo() throws ApiException {
            return ServiceLevelObjectivesApi.this.getSLOWithHttpInfo(this.sloId);
        }
    }

    public class APIdeleteSLOTimeframeInBulkRequest {
        private Map<String, List<SLOTimeframe>> body;

        private APIdeleteSLOTimeframeInBulkRequest() {
        }

        public APIdeleteSLOTimeframeInBulkRequest body(Map<String, List<SLOTimeframe>> body) {
            this.body = body;
            return this;
        }

        public SLOBulkDeleteResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SLOBulkDeleteResponse> executeWithHttpInfo() throws ApiException {
            return ServiceLevelObjectivesApi.this.deleteSLOTimeframeInBulkWithHttpInfo(this.body);
        }
    }

    public class APIdeleteSLORequest {
        private String sloId;
        private String force;

        private APIdeleteSLORequest(String sloId) {
            this.sloId = sloId;
        }

        public APIdeleteSLORequest force(String force) {
            this.force = force;
            return this;
        }

        public SLODeleteResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SLODeleteResponse> executeWithHttpInfo() throws ApiException {
            return ServiceLevelObjectivesApi.this.deleteSLOWithHttpInfo(this.sloId, this.force);
        }
    }

    public class APIcreateSLORequest {
        private ServiceLevelObjectiveRequest body;

        private APIcreateSLORequest() {
        }

        public APIcreateSLORequest body(ServiceLevelObjectiveRequest body) {
            this.body = body;
            return this;
        }

        public SLOListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SLOListResponse> executeWithHttpInfo() throws ApiException {
            return ServiceLevelObjectivesApi.this.createSLOWithHttpInfo(this.body);
        }
    }

    public class APIcheckCanDeleteSLORequest {
        private String ids;

        private APIcheckCanDeleteSLORequest() {
        }

        public APIcheckCanDeleteSLORequest ids(String ids) {
            this.ids = ids;
            return this;
        }

        public CheckCanDeleteSLOResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<CheckCanDeleteSLOResponse> executeWithHttpInfo() throws ApiException {
            return ServiceLevelObjectivesApi.this.checkCanDeleteSLOWithHttpInfo(this.ids);
        }
    }
}

