/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.jdbc.api.impl.converters.IntConverter;
import com.databricks.jdbc.api.impl.converters.ObjectConverter;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;

public class TimestampConverter
implements ObjectConverter {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(IntConverter.class);

    @Override
    public Time toTime(Object object) throws DatabricksSQLException {
        Timestamp timestamp = this.toTimestamp(object);
        LocalTime localTime = timestamp.toLocalDateTime().toLocalTime();
        long epochWithMillis = Time.valueOf(localTime).getTime() + timestamp.getTime() % 1000L;
        return new Time(epochWithMillis);
    }

    @Override
    public Timestamp toTimestamp(Object object) throws DatabricksSQLException {
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof String) {
            return this.parseStringToTimestamp((String)object);
        }
        throw new DatabricksSQLException("Unsupported conversion to Timestamp for type: " + object.getClass().getName(), DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    @Override
    public long toLong(Object object) throws DatabricksSQLException {
        return this.toTimestamp(object).toInstant().toEpochMilli();
    }

    @Override
    public BigInteger toBigInteger(Object object) throws DatabricksSQLException {
        return BigInteger.valueOf(this.toLong(object));
    }

    @Override
    public String toString(Object object) throws DatabricksSQLException {
        return this.toTimestamp(object).toInstant().toString();
    }

    @Override
    public Date toDate(Object object) throws DatabricksSQLException {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Timestamp) {
            return new Date(((Timestamp)object).getTime());
        }
        if (object instanceof String) {
            Timestamp ts = this.parseStringToTimestamp((String)object);
            LocalDate date = ts.toLocalDateTime().toLocalDate();
            return Date.valueOf(date);
        }
        return new Date(this.toLong(object));
    }

    private Timestamp parseStringToTimestamp(String inputTimestamp) throws DatabricksSQLException {
        try {
            if (inputTimestamp.matches(".*T.*([+\\-]\\d\\d:\\d\\d)$")) {
                OffsetDateTime odt = OffsetDateTime.parse(inputTimestamp);
                return Timestamp.valueOf(odt.toLocalDateTime());
            }
            String tsStr = inputTimestamp.replace("T", " ");
            return Timestamp.valueOf(tsStr);
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            LOGGER.error("Failed to parse timestamp: {}", inputTimestamp, e);
            try {
                Instant instant = Instant.parse(inputTimestamp);
                return Timestamp.from(instant);
            }
            catch (Exception ex) {
                throw new DatabricksSQLException("Invalid conversion to Timestamp for input: " + inputTimestamp, (Throwable)ex, DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
            }
        }
    }
}

