/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import com.databricks.internal.apache.http.HttpResponse;
import com.databricks.internal.apache.http.client.methods.HttpGet;
import com.databricks.internal.apache.http.client.utils.URIBuilder;
import com.databricks.internal.sdk.service.sql.BaseChunkInfo;
import com.databricks.jdbc.api.impl.arrow.AbstractArrowResultChunk;
import com.databricks.jdbc.api.impl.arrow.ChunkStatus;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.common.DatabricksJdbcUrlParams;
import com.databricks.jdbc.common.util.DatabricksThriftUtil;
import com.databricks.jdbc.common.util.DecompressionUtil;
import com.databricks.jdbc.common.util.ValidationUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TSparkArrowResultLink;
import com.databricks.jdbc.model.core.ExternalLink;
import com.databricks.jdbc.telemetry.TelemetryHelper;
import com.databricks.jdbc.telemetry.latency.TelemetryCollector;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Map;

public class ArrowResultChunk
extends AbstractArrowResultChunk {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(ArrowResultChunk.class);

    private ArrowResultChunk(Builder builder) throws DatabricksParsingException {
        super(builder.numRows, builder.rowOffset, builder.chunkIndex, builder.statementId, builder.status, builder.chunkLink, builder.expiryTime, builder.chunkReadyTimeoutSeconds);
        if (builder.inputStream != null) {
            try {
                this.initializeData(builder.inputStream);
            }
            catch (DatabricksSQLException | IOException e) {
                this.handleFailure(e, ChunkStatus.PROCESSING_FAILED);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void downloadData(IDatabricksHttpClient httpClient, CompressionCodec compressionCodec, double speedThreshold) throws DatabricksParsingException, IOException {
        long startTime = System.nanoTime();
        try (Closeable response = null;){
            URIBuilder uriBuilder = new URIBuilder(this.chunkLink.getExternalLink());
            HttpGet getRequest = new HttpGet(uriBuilder.build());
            this.addHeaders(getRequest, this.chunkLink.getHttpHeaders());
            response = httpClient.execute(getRequest, true);
            ValidationUtil.checkHTTPError((HttpResponse)((Object)response));
            long downloadTimeMs = (System.nanoTime() - startTime) / 1000000L;
            long contentLength = response.getEntity().getContentLength();
            this.logDownloadMetrics(downloadTimeMs, contentLength, this.chunkLink.getExternalLink(), speedThreshold);
            TelemetryCollector.getInstance().recordChunkDownloadLatency(TelemetryHelper.getStatementIdString(this.statementId), this.chunkIndex, downloadTimeMs);
            this.setStatus(ChunkStatus.DOWNLOAD_SUCCEEDED);
            String decompressionContext = String.format("Data decompression for chunk index [%d] and statement [%s]", this.chunkIndex, this.statementId);
            InputStream uncompressedStream = DecompressionUtil.decompress(response.getEntity().getContent(), compressionCodec, decompressionContext);
            this.initializeData(uncompressedStream);
        }
    }

    @Override
    protected void handleFailure(Exception exception, ChunkStatus failedStatus) throws DatabricksParsingException {
        this.errorMessage = String.format("Data parsing failed for chunk index [%d] and statement [%s]. Exception [%s]", this.chunkIndex, this.statementId, exception);
        LOGGER.error(this.errorMessage);
        this.setStatus(failedStatus);
        throw new DatabricksParsingException(this.errorMessage, (Throwable)exception, failedStatus.toString());
    }

    private void addHeaders(HttpGet getRequest, Map<String, String> headers) {
        if (headers != null) {
            headers.forEach(getRequest::addHeader);
        } else {
            LOGGER.debug("No encryption headers present for chunk index %s and statement %s", this.chunkIndex, this.statementId);
        }
    }

    private void logDownloadMetrics(long downloadTimeMs, long contentLength, String url, double speedThreshold) {
        if (downloadTimeMs > 0L && contentLength > 0L) {
            double speedMBps = (double)contentLength / 1024.0 / 1024.0 / ((double)downloadTimeMs / 1000.0);
            String baseUrl = url.split("\\?")[0];
            LOGGER.info(String.format("CloudFetch download: %.4f MB/s, %d bytes in %dms from %s", speedMBps, contentLength, downloadTimeMs, baseUrl));
            if (speedMBps < speedThreshold) {
                LOGGER.warn(String.format("CloudFetch download slower than threshold: %.4f MB/s < %.4f MB/s", speedMBps, speedThreshold));
            }
        }
    }

    public static class Builder {
        private long chunkIndex;
        private long numRows;
        private long rowOffset;
        private ExternalLink chunkLink;
        private StatementId statementId;
        private Instant expiryTime;
        private ChunkStatus status;
        private InputStream inputStream;
        private int chunkReadyTimeoutSeconds = Integer.parseInt(DatabricksJdbcUrlParams.CHUNK_READY_TIMEOUT_SECONDS.getDefaultValue());

        public Builder withStatementId(StatementId statementId) {
            this.statementId = statementId;
            return this;
        }

        public Builder withChunkInfo(BaseChunkInfo baseChunkInfo) {
            this.chunkIndex = baseChunkInfo.getChunkIndex();
            this.numRows = baseChunkInfo.getRowCount();
            this.rowOffset = baseChunkInfo.getRowOffset();
            this.status = this.status == null ? ChunkStatus.PENDING : this.status;
            return this;
        }

        public Builder withInputStream(InputStream stream, long rowCount) {
            this.numRows = rowCount;
            this.inputStream = stream;
            this.status = this.status == null ? ChunkStatus.DOWNLOAD_SUCCEEDED : this.status;
            return this;
        }

        public Builder withThriftChunkInfo(long chunkIndex, TSparkArrowResultLink chunkInfo) {
            this.chunkIndex = chunkIndex;
            this.numRows = chunkInfo.getRowCount();
            this.rowOffset = chunkInfo.getStartRowOffset();
            this.expiryTime = Instant.ofEpochMilli(chunkInfo.getExpiryTime());
            this.status = this.status == null ? ChunkStatus.URL_FETCHED : this.status;
            this.chunkLink = DatabricksThriftUtil.createExternalLink(chunkInfo, chunkIndex);
            return this;
        }

        public Builder withChunkStatus(ChunkStatus status) {
            this.status = status;
            return this;
        }

        public Builder withChunkReadyTimeoutSeconds(int chunkReadyTimeoutSeconds) {
            this.chunkReadyTimeoutSeconds = chunkReadyTimeoutSeconds;
            return this;
        }

        public ArrowResultChunk build() throws DatabricksParsingException {
            return new ArrowResultChunk(this);
        }
    }
}

