/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.google.common.base.MoreObjects;
import com.databricks.internal.google.common.primitives.Booleans;
import com.databricks.internal.google.errorprone.annotations.CanIgnoreReturnValue;
import com.databricks.jdbc.api.impl.DatabricksColumn;
import com.databricks.jdbc.common.AccessType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DatabricksColumn", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableDatabricksColumn
implements DatabricksColumn {
    private final String columnName;
    private final int columnType;
    private final String columnTypeText;
    private final int typePrecision;
    private final int displaySize;
    private final boolean isSigned;
    @Nullable
    private final String schemaName;
    private final boolean isCurrency;
    private final boolean isAutoIncrement;
    private final boolean isCaseSensitive;
    private final boolean isSearchable;
    private final com.databricks.jdbc.common.Nullable nullable;
    private final int typeScale;
    private final AccessType accessType;
    private final boolean isDefinitelyWritable;
    private final String columnTypeClassName;
    @Nullable
    private final String tableName;
    private final String catalogName;

    private ImmutableDatabricksColumn(String columnName, int columnType, String columnTypeText, int typePrecision, int displaySize, boolean isSigned, @Nullable String schemaName, boolean isCurrency, boolean isAutoIncrement, boolean isCaseSensitive, boolean isSearchable, com.databricks.jdbc.common.Nullable nullable, int typeScale, AccessType accessType, boolean isDefinitelyWritable, String columnTypeClassName, @Nullable String tableName, String catalogName) {
        this.columnName = columnName;
        this.columnType = columnType;
        this.columnTypeText = columnTypeText;
        this.typePrecision = typePrecision;
        this.displaySize = displaySize;
        this.isSigned = isSigned;
        this.schemaName = schemaName;
        this.isCurrency = isCurrency;
        this.isAutoIncrement = isAutoIncrement;
        this.isCaseSensitive = isCaseSensitive;
        this.isSearchable = isSearchable;
        this.nullable = nullable;
        this.typeScale = typeScale;
        this.accessType = accessType;
        this.isDefinitelyWritable = isDefinitelyWritable;
        this.columnTypeClassName = columnTypeClassName;
        this.tableName = tableName;
        this.catalogName = catalogName;
    }

    @Override
    public String columnName() {
        return this.columnName;
    }

    @Override
    public int columnType() {
        return this.columnType;
    }

    @Override
    public String columnTypeText() {
        return this.columnTypeText;
    }

    @Override
    public int typePrecision() {
        return this.typePrecision;
    }

    @Override
    public int displaySize() {
        return this.displaySize;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    @Nullable
    public String schemaName() {
        return this.schemaName;
    }

    @Override
    public boolean isCurrency() {
        return this.isCurrency;
    }

    @Override
    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public boolean isSearchable() {
        return this.isSearchable;
    }

    @Override
    public com.databricks.jdbc.common.Nullable nullable() {
        return this.nullable;
    }

    @Override
    public int typeScale() {
        return this.typeScale;
    }

    @Override
    public AccessType accessType() {
        return this.accessType;
    }

    @Override
    public boolean isDefinitelyWritable() {
        return this.isDefinitelyWritable;
    }

    @Override
    public String columnTypeClassName() {
        return this.columnTypeClassName;
    }

    @Override
    @Nullable
    public String tableName() {
        return this.tableName;
    }

    @Override
    public String catalogName() {
        return this.catalogName;
    }

    public final ImmutableDatabricksColumn withColumnName(String value) {
        String newValue = Objects.requireNonNull(value, "columnName");
        if (this.columnName.equals(newValue)) {
            return this;
        }
        return new ImmutableDatabricksColumn(newValue, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withColumnType(int value) {
        if (this.columnType == value) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, value, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withColumnTypeText(String value) {
        String newValue = Objects.requireNonNull(value, "columnTypeText");
        if (this.columnTypeText.equals(newValue)) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, newValue, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withTypePrecision(int value) {
        if (this.typePrecision == value) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, value, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withDisplaySize(int value) {
        if (this.displaySize == value) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, value, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withIsSigned(boolean value) {
        if (this.isSigned == value) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, value, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withSchemaName(@Nullable String value) {
        if (Objects.equals(this.schemaName, value)) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, value, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withIsCurrency(boolean value) {
        if (this.isCurrency == value) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, value, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withIsAutoIncrement(boolean value) {
        if (this.isAutoIncrement == value) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, value, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withIsCaseSensitive(boolean value) {
        if (this.isCaseSensitive == value) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, value, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withIsSearchable(boolean value) {
        if (this.isSearchable == value) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, value, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withNullable(com.databricks.jdbc.common.Nullable value) {
        com.databricks.jdbc.common.Nullable newValue = Objects.requireNonNull(value, "nullable");
        if (this.nullable == newValue) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, newValue, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withTypeScale(int value) {
        if (this.typeScale == value) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, value, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withAccessType(AccessType value) {
        AccessType newValue = Objects.requireNonNull(value, "accessType");
        if (this.accessType == newValue) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, newValue, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withIsDefinitelyWritable(boolean value) {
        if (this.isDefinitelyWritable == value) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, value, this.columnTypeClassName, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withColumnTypeClassName(String value) {
        String newValue = Objects.requireNonNull(value, "columnTypeClassName");
        if (this.columnTypeClassName.equals(newValue)) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, newValue, this.tableName, this.catalogName);
    }

    public final ImmutableDatabricksColumn withTableName(@Nullable String value) {
        if (Objects.equals(this.tableName, value)) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, value, this.catalogName);
    }

    public final ImmutableDatabricksColumn withCatalogName(String value) {
        String newValue = Objects.requireNonNull(value, "catalogName");
        if (this.catalogName.equals(newValue)) {
            return this;
        }
        return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDatabricksColumn && this.equalTo(0, (ImmutableDatabricksColumn)another);
    }

    private boolean equalTo(int synthetic, ImmutableDatabricksColumn another) {
        return this.columnName.equals(another.columnName) && this.columnType == another.columnType && this.columnTypeText.equals(another.columnTypeText) && this.typePrecision == another.typePrecision && this.displaySize == another.displaySize && this.isSigned == another.isSigned && Objects.equals(this.schemaName, another.schemaName) && this.isCurrency == another.isCurrency && this.isAutoIncrement == another.isAutoIncrement && this.isCaseSensitive == another.isCaseSensitive && this.isSearchable == another.isSearchable && this.nullable.equals((Object)another.nullable) && this.typeScale == another.typeScale && this.accessType.equals((Object)another.accessType) && this.isDefinitelyWritable == another.isDefinitelyWritable && this.columnTypeClassName.equals(another.columnTypeClassName) && Objects.equals(this.tableName, another.tableName) && this.catalogName.equals(another.catalogName);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.columnName.hashCode();
        h2 += (h2 << 5) + this.columnType;
        h2 += (h2 << 5) + this.columnTypeText.hashCode();
        h2 += (h2 << 5) + this.typePrecision;
        h2 += (h2 << 5) + this.displaySize;
        h2 += (h2 << 5) + Booleans.hashCode(this.isSigned);
        h2 += (h2 << 5) + Objects.hashCode(this.schemaName);
        h2 += (h2 << 5) + Booleans.hashCode(this.isCurrency);
        h2 += (h2 << 5) + Booleans.hashCode(this.isAutoIncrement);
        h2 += (h2 << 5) + Booleans.hashCode(this.isCaseSensitive);
        h2 += (h2 << 5) + Booleans.hashCode(this.isSearchable);
        h2 += (h2 << 5) + this.nullable.hashCode();
        h2 += (h2 << 5) + this.typeScale;
        h2 += (h2 << 5) + this.accessType.hashCode();
        h2 += (h2 << 5) + Booleans.hashCode(this.isDefinitelyWritable);
        h2 += (h2 << 5) + this.columnTypeClassName.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.tableName);
        h2 += (h2 << 5) + this.catalogName.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("DatabricksColumn").omitNullValues().add("columnName", this.columnName).add("columnType", this.columnType).add("columnTypeText", this.columnTypeText).add("typePrecision", this.typePrecision).add("displaySize", this.displaySize).add("isSigned", this.isSigned).add("schemaName", this.schemaName).add("isCurrency", this.isCurrency).add("isAutoIncrement", this.isAutoIncrement).add("isCaseSensitive", this.isCaseSensitive).add("isSearchable", this.isSearchable).add("nullable", (Object)this.nullable).add("typeScale", this.typeScale).add("accessType", (Object)this.accessType).add("isDefinitelyWritable", this.isDefinitelyWritable).add("columnTypeClassName", this.columnTypeClassName).add("tableName", this.tableName).add("catalogName", this.catalogName).toString();
    }

    public static ImmutableDatabricksColumn copyOf(DatabricksColumn instance) {
        if (instance instanceof ImmutableDatabricksColumn) {
            return (ImmutableDatabricksColumn)instance;
        }
        return ImmutableDatabricksColumn.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DatabricksColumn", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COLUMN_NAME = 1L;
        private static final long INIT_BIT_COLUMN_TYPE = 2L;
        private static final long INIT_BIT_COLUMN_TYPE_TEXT = 4L;
        private static final long INIT_BIT_TYPE_PRECISION = 8L;
        private static final long INIT_BIT_DISPLAY_SIZE = 16L;
        private static final long INIT_BIT_IS_SIGNED = 32L;
        private static final long INIT_BIT_IS_CURRENCY = 64L;
        private static final long INIT_BIT_IS_AUTO_INCREMENT = 128L;
        private static final long INIT_BIT_IS_CASE_SENSITIVE = 256L;
        private static final long INIT_BIT_IS_SEARCHABLE = 512L;
        private static final long INIT_BIT_NULLABLE = 1024L;
        private static final long INIT_BIT_TYPE_SCALE = 2048L;
        private static final long INIT_BIT_ACCESS_TYPE = 4096L;
        private static final long INIT_BIT_IS_DEFINITELY_WRITABLE = 8192L;
        private static final long INIT_BIT_COLUMN_TYPE_CLASS_NAME = 16384L;
        private static final long INIT_BIT_CATALOG_NAME = 32768L;
        private long initBits = 65535L;
        @Nullable
        private String columnName;
        private int columnType;
        @Nullable
        private String columnTypeText;
        private int typePrecision;
        private int displaySize;
        private boolean isSigned;
        @Nullable
        private String schemaName;
        private boolean isCurrency;
        private boolean isAutoIncrement;
        private boolean isCaseSensitive;
        private boolean isSearchable;
        @Nullable
        private com.databricks.jdbc.common.Nullable nullable;
        private int typeScale;
        @Nullable
        private AccessType accessType;
        private boolean isDefinitelyWritable;
        @Nullable
        private String columnTypeClassName;
        @Nullable
        private String tableName;
        @Nullable
        private String catalogName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DatabricksColumn instance) {
            Objects.requireNonNull(instance, "instance");
            this.columnName(instance.columnName());
            this.columnType(instance.columnType());
            this.columnTypeText(instance.columnTypeText());
            this.typePrecision(instance.typePrecision());
            this.displaySize(instance.displaySize());
            this.isSigned(instance.isSigned());
            String schemaNameValue = instance.schemaName();
            if (schemaNameValue != null) {
                this.schemaName(schemaNameValue);
            }
            this.isCurrency(instance.isCurrency());
            this.isAutoIncrement(instance.isAutoIncrement());
            this.isCaseSensitive(instance.isCaseSensitive());
            this.isSearchable(instance.isSearchable());
            this.nullable(instance.nullable());
            this.typeScale(instance.typeScale());
            this.accessType(instance.accessType());
            this.isDefinitelyWritable(instance.isDefinitelyWritable());
            this.columnTypeClassName(instance.columnTypeClassName());
            String tableNameValue = instance.tableName();
            if (tableNameValue != null) {
                this.tableName(tableNameValue);
            }
            this.catalogName(instance.catalogName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder columnName(String columnName) {
            this.columnName = Objects.requireNonNull(columnName, "columnName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder columnType(int columnType) {
            this.columnType = columnType;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder columnTypeText(String columnTypeText) {
            this.columnTypeText = Objects.requireNonNull(columnTypeText, "columnTypeText");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder typePrecision(int typePrecision) {
            this.typePrecision = typePrecision;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder displaySize(int displaySize) {
            this.displaySize = displaySize;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isSigned(boolean isSigned) {
            this.isSigned = isSigned;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaName(@Nullable String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isCurrency(boolean isCurrency) {
            this.isCurrency = isCurrency;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isAutoIncrement(boolean isAutoIncrement) {
            this.isAutoIncrement = isAutoIncrement;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isCaseSensitive(boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isSearchable(boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nullable(com.databricks.jdbc.common.Nullable nullable) {
            this.nullable = Objects.requireNonNull(nullable, "nullable");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder typeScale(int typeScale) {
            this.typeScale = typeScale;
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accessType(AccessType accessType) {
            this.accessType = Objects.requireNonNull(accessType, "accessType");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isDefinitelyWritable(boolean isDefinitelyWritable) {
            this.isDefinitelyWritable = isDefinitelyWritable;
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder columnTypeClassName(String columnTypeClassName) {
            this.columnTypeClassName = Objects.requireNonNull(columnTypeClassName, "columnTypeClassName");
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tableName(@Nullable String tableName) {
            this.tableName = tableName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder catalogName(String catalogName) {
            this.catalogName = Objects.requireNonNull(catalogName, "catalogName");
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        public ImmutableDatabricksColumn build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDatabricksColumn(this.columnName, this.columnType, this.columnTypeText, this.typePrecision, this.displaySize, this.isSigned, this.schemaName, this.isCurrency, this.isAutoIncrement, this.isCaseSensitive, this.isSearchable, this.nullable, this.typeScale, this.accessType, this.isDefinitelyWritable, this.columnTypeClassName, this.tableName, this.catalogName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("columnName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("columnType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("columnTypeText");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("typePrecision");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("displaySize");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("isSigned");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("isCurrency");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("isAutoIncrement");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("isCaseSensitive");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("isSearchable");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("nullable");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("typeScale");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("accessType");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("isDefinitelyWritable");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("columnTypeClassName");
            }
            if ((this.initBits & 0x8000L) != 0L) {
                attributes.add("catalogName");
            }
            return "Cannot build DatabricksColumn, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

