/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.marketplace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.marketplace.ConsumerPersonalizationRequestsImpl;
import com.databricks.internal.sdk.service.marketplace.ConsumerPersonalizationRequestsService;
import com.databricks.internal.sdk.service.marketplace.CreatePersonalizationRequest;
import com.databricks.internal.sdk.service.marketplace.CreatePersonalizationRequestResponse;
import com.databricks.internal.sdk.service.marketplace.GetPersonalizationRequestRequest;
import com.databricks.internal.sdk.service.marketplace.GetPersonalizationRequestResponse;
import com.databricks.internal.sdk.service.marketplace.ListAllPersonalizationRequestsRequest;
import com.databricks.internal.sdk.service.marketplace.ListAllPersonalizationRequestsResponse;
import com.databricks.internal.sdk.service.marketplace.PersonalizationRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ConsumerPersonalizationRequestsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerPersonalizationRequestsAPI.class);
    private final ConsumerPersonalizationRequestsService impl;

    public ConsumerPersonalizationRequestsAPI(ApiClient apiClient) {
        this.impl = new ConsumerPersonalizationRequestsImpl(apiClient);
    }

    public ConsumerPersonalizationRequestsAPI(ConsumerPersonalizationRequestsService mock) {
        this.impl = mock;
    }

    public CreatePersonalizationRequestResponse create(CreatePersonalizationRequest request) {
        return this.impl.create(request);
    }

    public GetPersonalizationRequestResponse get(String listingId) {
        return this.get(new GetPersonalizationRequestRequest().setListingId(listingId));
    }

    public GetPersonalizationRequestResponse get(GetPersonalizationRequestRequest request) {
        return this.impl.get(request);
    }

    public Iterable<PersonalizationRequest> list(ListAllPersonalizationRequestsRequest request) {
        return new Paginator(request, this.impl::list, ListAllPersonalizationRequestsResponse::getPersonalizationRequests, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ConsumerPersonalizationRequestsService impl() {
        return this.impl;
    }
}

