/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.jobs;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.jobs.CancelAllRuns;
import com.databricks.internal.sdk.service.jobs.CancelRun;
import com.databricks.internal.sdk.service.jobs.CreateJob;
import com.databricks.internal.sdk.service.jobs.CreateResponse;
import com.databricks.internal.sdk.service.jobs.DeleteJob;
import com.databricks.internal.sdk.service.jobs.DeleteRun;
import com.databricks.internal.sdk.service.jobs.ExportRunOutput;
import com.databricks.internal.sdk.service.jobs.ExportRunRequest;
import com.databricks.internal.sdk.service.jobs.GetJobPermissionLevelsRequest;
import com.databricks.internal.sdk.service.jobs.GetJobPermissionLevelsResponse;
import com.databricks.internal.sdk.service.jobs.GetJobPermissionsRequest;
import com.databricks.internal.sdk.service.jobs.GetJobRequest;
import com.databricks.internal.sdk.service.jobs.GetRunOutputRequest;
import com.databricks.internal.sdk.service.jobs.GetRunRequest;
import com.databricks.internal.sdk.service.jobs.Job;
import com.databricks.internal.sdk.service.jobs.JobPermissions;
import com.databricks.internal.sdk.service.jobs.JobPermissionsRequest;
import com.databricks.internal.sdk.service.jobs.JobsService;
import com.databricks.internal.sdk.service.jobs.ListJobsRequest;
import com.databricks.internal.sdk.service.jobs.ListJobsResponse;
import com.databricks.internal.sdk.service.jobs.ListRunsRequest;
import com.databricks.internal.sdk.service.jobs.ListRunsResponse;
import com.databricks.internal.sdk.service.jobs.RepairRun;
import com.databricks.internal.sdk.service.jobs.RepairRunResponse;
import com.databricks.internal.sdk.service.jobs.ResetJob;
import com.databricks.internal.sdk.service.jobs.Run;
import com.databricks.internal.sdk.service.jobs.RunNow;
import com.databricks.internal.sdk.service.jobs.RunNowResponse;
import com.databricks.internal.sdk.service.jobs.RunOutput;
import com.databricks.internal.sdk.service.jobs.SubmitRun;
import com.databricks.internal.sdk.service.jobs.SubmitRunResponse;
import com.databricks.internal.sdk.service.jobs.UpdateJob;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class JobsImpl
implements JobsService {
    private final ApiClient apiClient;

    public JobsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void cancelAllRuns(CancelAllRuns request) {
        String path = "/api/2.2/jobs/runs/cancel-all";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void cancelRun(CancelRun request) {
        String path = "/api/2.2/jobs/runs/cancel";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CreateResponse create(CreateJob request) {
        String path = "/api/2.2/jobs/create";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteJob request) {
        String path = "/api/2.2/jobs/delete";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteRun(DeleteRun request) {
        String path = "/api/2.2/jobs/runs/delete";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ExportRunOutput exportRun(ExportRunRequest request) {
        String path = "/api/2.2/jobs/runs/export";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ExportRunOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Job get(GetJobRequest request) {
        String path = "/api/2.2/jobs/get";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Job.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetJobPermissionLevelsResponse getPermissionLevels(GetJobPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/jobs/%s/permissionLevels", request.getJobId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetJobPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public JobPermissions getPermissions(GetJobPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/jobs/%s", request.getJobId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, JobPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Run getRun(GetRunRequest request) {
        String path = "/api/2.2/jobs/runs/get";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Run.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RunOutput getRunOutput(GetRunOutputRequest request) {
        String path = "/api/2.2/jobs/runs/get-output";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, RunOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListJobsResponse list(ListJobsRequest request) {
        String path = "/api/2.2/jobs/list";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListJobsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListRunsResponse listRuns(ListRunsRequest request) {
        String path = "/api/2.2/jobs/runs/list";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListRunsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RepairRunResponse repairRun(RepairRun request) {
        String path = "/api/2.2/jobs/runs/repair";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RepairRunResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void reset(ResetJob request) {
        String path = "/api/2.2/jobs/reset";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RunNowResponse runNow(RunNow request) {
        String path = "/api/2.2/jobs/run-now";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RunNowResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public JobPermissions setPermissions(JobPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/jobs/%s", request.getJobId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, JobPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public SubmitRunResponse submit(SubmitRun request) {
        String path = "/api/2.2/jobs/runs/submit";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, SubmitRunResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(UpdateJob request) {
        String path = "/api/2.2/jobs/update";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public JobPermissions updatePermissions(JobPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/jobs/%s", request.getJobId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, JobPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

