/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.AccountMetastoreAssignmentsImpl;
import com.databricks.internal.sdk.service.catalog.AccountMetastoreAssignmentsService;
import com.databricks.internal.sdk.service.catalog.AccountsCreateMetastoreAssignment;
import com.databricks.internal.sdk.service.catalog.AccountsMetastoreAssignment;
import com.databricks.internal.sdk.service.catalog.AccountsUpdateMetastoreAssignment;
import com.databricks.internal.sdk.service.catalog.DeleteAccountMetastoreAssignmentRequest;
import com.databricks.internal.sdk.service.catalog.GetAccountMetastoreAssignmentRequest;
import com.databricks.internal.sdk.service.catalog.ListAccountMetastoreAssignmentsRequest;
import com.databricks.internal.sdk.service.catalog.ListAccountMetastoreAssignmentsResponse;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountMetastoreAssignmentsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountMetastoreAssignmentsAPI.class);
    private final AccountMetastoreAssignmentsService impl;

    public AccountMetastoreAssignmentsAPI(ApiClient apiClient) {
        this.impl = new AccountMetastoreAssignmentsImpl(apiClient);
    }

    public AccountMetastoreAssignmentsAPI(AccountMetastoreAssignmentsService mock) {
        this.impl = mock;
    }

    public void create(AccountsCreateMetastoreAssignment request) {
        this.impl.create(request);
    }

    public void delete(long workspaceId, String metastoreId) {
        this.delete(new DeleteAccountMetastoreAssignmentRequest().setWorkspaceId(workspaceId).setMetastoreId(metastoreId));
    }

    public void delete(DeleteAccountMetastoreAssignmentRequest request) {
        this.impl.delete(request);
    }

    public AccountsMetastoreAssignment get(long workspaceId) {
        return this.get(new GetAccountMetastoreAssignmentRequest().setWorkspaceId(workspaceId));
    }

    public AccountsMetastoreAssignment get(GetAccountMetastoreAssignmentRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Long> list(String metastoreId) {
        return this.list(new ListAccountMetastoreAssignmentsRequest().setMetastoreId(metastoreId));
    }

    public Iterable<Long> list(ListAccountMetastoreAssignmentsRequest request) {
        return new Paginator(request, this.impl::list, ListAccountMetastoreAssignmentsResponse::getWorkspaceIds, response -> null);
    }

    public void update(AccountsUpdateMetastoreAssignment request) {
        this.impl.update(request);
    }

    public AccountMetastoreAssignmentsService impl() {
        return this.impl;
    }
}

