/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.mixin;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.jobs.BaseJob;
import com.databricks.internal.sdk.service.jobs.BaseRun;
import com.databricks.internal.sdk.service.jobs.GetJobRequest;
import com.databricks.internal.sdk.service.jobs.GetRunRequest;
import com.databricks.internal.sdk.service.jobs.Job;
import com.databricks.internal.sdk.service.jobs.JobCluster;
import com.databricks.internal.sdk.service.jobs.JobEnvironment;
import com.databricks.internal.sdk.service.jobs.JobParameter;
import com.databricks.internal.sdk.service.jobs.JobParameterDefinition;
import com.databricks.internal.sdk.service.jobs.JobsAPI;
import com.databricks.internal.sdk.service.jobs.JobsService;
import com.databricks.internal.sdk.service.jobs.ListJobsRequest;
import com.databricks.internal.sdk.service.jobs.ListRunsRequest;
import com.databricks.internal.sdk.service.jobs.RepairHistoryItem;
import com.databricks.internal.sdk.service.jobs.Run;
import com.databricks.internal.sdk.service.jobs.RunTask;
import com.databricks.internal.sdk.service.jobs.Task;
import java.util.Collection;
import java.util.Iterator;

public class JobsExt
extends JobsAPI {
    public JobsExt(ApiClient apiClient) {
        super(apiClient);
    }

    public JobsExt(JobsService mock) {
        super(mock);
    }

    @Override
    public Iterable<BaseJob> list(ListJobsRequest request) {
        Iterable<BaseJob> jobsList = super.list(request);
        if (!request.getExpandTasks().booleanValue()) {
            return jobsList;
        }
        final Iterator<BaseJob> iterator = jobsList.iterator();
        return () -> new Iterator<BaseJob>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public BaseJob next() {
                BaseJob job = (BaseJob)iterator.next();
                if (job.getHasMore() != null && job.getHasMore().booleanValue()) {
                    GetJobRequest getJobRequest = new GetJobRequest().setJobId(job.getJobId());
                    Job fullJob = JobsExt.this.get(getJobRequest);
                    job.getSettings().setTasks(fullJob.getSettings().getTasks());
                    job.getSettings().setJobClusters(fullJob.getSettings().getJobClusters());
                    job.getSettings().setParameters(fullJob.getSettings().getParameters());
                    job.getSettings().setEnvironments(fullJob.getSettings().getEnvironments());
                }
                job.setHasMore(null);
                return job;
            }
        };
    }

    @Override
    public Iterable<BaseRun> listRuns(ListRunsRequest request) {
        Iterable<BaseRun> runsList = super.listRuns(request);
        if (!request.getExpandTasks().booleanValue()) {
            return runsList;
        }
        final Iterator<BaseRun> iterator = runsList.iterator();
        return () -> new Iterator<BaseRun>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public BaseRun next() {
                BaseRun run = (BaseRun)iterator.next();
                if (run.getHasMore() != null && run.getHasMore().booleanValue()) {
                    GetRunRequest getRunRequest = new GetRunRequest().setRunId(run.getRunId());
                    Run fullRun = JobsExt.this.getRun(getRunRequest);
                    run.setTasks(fullRun.getTasks());
                    run.setJobClusters(fullRun.getJobClusters());
                    run.setJobParameters(fullRun.getJobParameters());
                    run.setRepairHistory(fullRun.getRepairHistory());
                }
                run.setHasMore(null);
                return run;
            }
        };
    }

    @Override
    public Run getRun(GetRunRequest request) {
        boolean paginatingIterations;
        Run run = super.getRun(request);
        Collection<RunTask> iterations = run.getIterations();
        boolean bl = paginatingIterations = iterations != null && !iterations.isEmpty();
        while (run.getNextPageToken() != null) {
            Collection<RepairHistoryItem> newRepairHistory;
            Collection<JobParameter> newParameters;
            request.setPageToken(run.getNextPageToken());
            Run currRun = super.getRun(request);
            if (paginatingIterations) {
                Collection<RunTask> newIterations = currRun.getIterations();
                if (newIterations != null) {
                    run.getIterations().addAll(newIterations);
                }
            } else {
                Collection<RunTask> newTasks = currRun.getTasks();
                if (newTasks != null) {
                    run.getTasks().addAll(newTasks);
                }
            }
            Collection<JobCluster> newClusters = currRun.getJobClusters();
            if (newClusters != null) {
                run.getJobClusters().addAll(newClusters);
            }
            if ((newParameters = currRun.getJobParameters()) != null) {
                run.getJobParameters().addAll(newParameters);
            }
            if ((newRepairHistory = currRun.getRepairHistory()) != null) {
                run.getRepairHistory().addAll(newRepairHistory);
            }
            run.setNextPageToken(currRun.getNextPageToken());
        }
        return run;
    }

    @Override
    public Job get(GetJobRequest request) {
        Job job = super.get(request);
        while (job.getNextPageToken() != null) {
            Collection<JobEnvironment> newEnvironments;
            Collection<JobParameterDefinition> newParameters;
            Collection<JobCluster> newClusters;
            request.setPageToken(job.getNextPageToken());
            Job currJob = super.get(request);
            Collection<Task> newTasks = currJob.getSettings().getTasks();
            if (newTasks != null) {
                job.getSettings().getTasks().addAll(newTasks);
            }
            if ((newClusters = currJob.getSettings().getJobClusters()) != null) {
                job.getSettings().getJobClusters().addAll(newClusters);
            }
            if ((newParameters = currJob.getSettings().getParameters()) != null) {
                job.getSettings().getParameters().addAll(newParameters);
            }
            if ((newEnvironments = currJob.getSettings().getEnvironments()) != null) {
                job.getSettings().getEnvironments().addAll(newEnvironments);
            }
            job.setNextPageToken(currJob.getNextPageToken());
        }
        return job;
    }
}

