/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.nimbusds.jose;

import com.databricks.internal.nimbusds.jose.Algorithm;
import com.databricks.internal.nimbusds.jose.HeaderValidation;
import com.databricks.internal.nimbusds.jose.IllegalHeaderException;
import com.databricks.internal.nimbusds.jose.JOSEObjectType;
import com.databricks.internal.nimbusds.jose.JWEAlgorithm;
import com.databricks.internal.nimbusds.jose.JWEHeader;
import com.databricks.internal.nimbusds.jose.JWSAlgorithm;
import com.databricks.internal.nimbusds.jose.JWSHeader;
import com.databricks.internal.nimbusds.jose.PlainHeader;
import com.databricks.internal.nimbusds.jose.UnprotectedHeader;
import com.databricks.internal.nimbusds.jose.util.Base64URL;
import com.databricks.internal.nimbusds.jose.util.JSONObjectUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Header
implements Serializable {
    public static final int MAX_HEADER_STRING_LENGTH = 20000;
    private static final long serialVersionUID = 1L;
    private final Algorithm alg;
    private final JOSEObjectType typ;
    private final String cty;
    private final Set<String> crit;
    private final Map<String, Object> customParams;
    private static final Map<String, Object> EMPTY_CUSTOM_PARAMS = Collections.unmodifiableMap(new HashMap());
    private final Base64URL parsedBase64URL;

    protected Header(Algorithm alg, JOSEObjectType typ, String cty, Set<String> crit, Map<String, Object> customParams, Base64URL parsedBase64URL) {
        this.alg = alg;
        this.typ = typ;
        this.cty = cty;
        this.crit = crit != null ? Collections.unmodifiableSet(new HashSet<String>(crit)) : null;
        this.customParams = customParams != null ? Collections.unmodifiableMap(new HashMap<String, Object>(customParams)) : EMPTY_CUSTOM_PARAMS;
        this.parsedBase64URL = parsedBase64URL;
    }

    protected Header(Header header) {
        this(header.getAlgorithm(), header.getType(), header.getContentType(), header.getCriticalParams(), header.getCustomParams(), header.getParsedBase64URL());
    }

    public Algorithm getAlgorithm() {
        return this.alg;
    }

    public JOSEObjectType getType() {
        return this.typ;
    }

    public String getContentType() {
        return this.cty;
    }

    public Set<String> getCriticalParams() {
        return this.crit;
    }

    public Object getCustomParam(String name) {
        return this.customParams.get(name);
    }

    public Map<String, Object> getCustomParams() {
        return this.customParams;
    }

    public Base64URL getParsedBase64URL() {
        return this.parsedBase64URL;
    }

    public Set<String> getIncludedParams() {
        HashSet<String> includedParameters = new HashSet<String>(this.getCustomParams().keySet());
        if (this.getAlgorithm() != null) {
            includedParameters.add("alg");
        }
        if (this.getType() != null) {
            includedParameters.add("typ");
        }
        if (this.getContentType() != null) {
            includedParameters.add("cty");
        }
        if (this.getCriticalParams() != null && !this.getCriticalParams().isEmpty()) {
            includedParameters.add("crit");
        }
        return includedParameters;
    }

    public Map<String, Object> toJSONObject() {
        Map<String, Object> o = JSONObjectUtils.newJSONObject();
        o.putAll(this.customParams);
        if (this.alg != null) {
            o.put("alg", this.alg.toString());
        }
        if (this.typ != null) {
            o.put("typ", this.typ.toString());
        }
        if (this.cty != null) {
            o.put("cty", this.cty);
        }
        if (this.crit != null && !this.crit.isEmpty()) {
            o.put("crit", new ArrayList<String>(this.crit));
        }
        return o;
    }

    public String toString() {
        return JSONObjectUtils.toJSONString(this.toJSONObject());
    }

    public Base64URL toBase64URL() {
        if (this.parsedBase64URL == null) {
            return Base64URL.encode(this.toString());
        }
        return this.parsedBase64URL;
    }

    public static Algorithm parseAlgorithm(Map<String, Object> json) throws ParseException {
        String algName = JSONObjectUtils.getString(json, "alg");
        if (algName == null) {
            throw new ParseException("Missing \"alg\" in header JSON object", 0);
        }
        if (algName.equals(Algorithm.NONE.getName())) {
            return Algorithm.NONE;
        }
        if (json.containsKey("enc")) {
            return JWEAlgorithm.parse(algName);
        }
        return JWSAlgorithm.parse(algName);
    }

    public Header join(UnprotectedHeader unprotected) throws ParseException {
        Map<String, Object> jsonObject = this.toJSONObject();
        try {
            HeaderValidation.ensureDisjoint(this, unprotected);
        }
        catch (IllegalHeaderException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        if (unprotected != null) {
            jsonObject.putAll(unprotected.toJSONObject());
        }
        return Header.parse(jsonObject, null);
    }

    public static Header parse(Map<String, Object> jsonObject) throws ParseException {
        return Header.parse(jsonObject, null);
    }

    public static Header parse(Map<String, Object> jsonObject, Base64URL parsedBase64URL) throws ParseException {
        String algName = JSONObjectUtils.getString(jsonObject, "alg");
        if (jsonObject.containsKey("enc")) {
            return JWEHeader.parse(jsonObject, parsedBase64URL);
        }
        if (Algorithm.NONE.getName().equals(algName)) {
            return PlainHeader.parse(jsonObject, parsedBase64URL);
        }
        if (jsonObject.containsKey("alg")) {
            return JWSHeader.parse(jsonObject, parsedBase64URL);
        }
        throw new ParseException("Missing \"alg\" in header JSON object", 0);
    }

    public static Header parse(String jsonString) throws ParseException {
        return Header.parse(jsonString, null);
    }

    public static Header parse(String jsonString, Base64URL parsedBase64URL) throws ParseException {
        Map<String, Object> jsonObject = JSONObjectUtils.parse(jsonString, 20000);
        return Header.parse(jsonObject, parsedBase64URL);
    }

    public static Header parse(Base64URL base64URL) throws ParseException {
        return Header.parse(base64URL.decodeToString(), base64URL);
    }
}

