/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.pqc.crypto.frodo;

import com.databricks.internal.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.databricks.internal.bouncycastle.crypto.SecretWithEncapsulation;
import com.databricks.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.databricks.internal.bouncycastle.pqc.crypto.frodo.FrodoEngine;
import com.databricks.internal.bouncycastle.pqc.crypto.frodo.FrodoPublicKeyParameters;
import com.databricks.internal.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import java.security.SecureRandom;

public class FrodoKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public FrodoKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        FrodoPublicKeyParameters frodoPublicKeyParameters = (FrodoPublicKeyParameters)asymmetricKeyParameter;
        FrodoEngine frodoEngine = frodoPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[frodoEngine.getCipherTextSize()];
        byte[] byArray2 = new byte[frodoEngine.getSessionKeySize()];
        frodoEngine.kem_enc(byArray, byArray2, frodoPublicKeyParameters.getPublicKey(), this.sr);
        return new SecretWithEncapsulationImpl(byArray2, byArray);
    }
}

