/*
 * Decompiled with CFR 0.152.
 */
package com.darrinholst.sass_java;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jruby.embed.ScriptingContainer;

public class Compiler {
    private boolean initialized;
    private File configLocation;

    public void compile() {
        this.initialize();
        new ScriptingContainer().runScriptlet(this.buildCompileScript());
    }

    private void initialize() {
        if (!this.initialized) {
            new ScriptingContainer().runScriptlet(this.buildInitializationScript());
            this.initialized = true;
        }
    }

    private String buildCompileScript() {
        StringWriter raw = new StringWriter();
        PrintWriter script = new PrintWriter(raw);
        script.println("Dir.chdir(File.dirname('" + this.getConfigLocation() + "')) do ");
        script.println("  compiler = Compass.sass_compiler                        ");
        script.println("  compiler.logger = Compass::NullLogger.new               ");
        script.println("  compiler.clean!                                         ");
        script.println("  compiler.compile!                                       ");
        script.println("end                                                       ");
        script.flush();
        return raw.toString();
    }

    private String buildInitializationScript() {
        StringWriter raw = new StringWriter();
        PrintWriter script = new PrintWriter(raw);
        script.println("require 'compass'                                               ");
        script.println("require 'compass/sass_compiler'                                 ");
        script.println("Compass.add_project_configuration '" + this.getConfigLocation() + "' ");
        script.println("Compass.configure_sass_plugin!                                  ");
        script.flush();
        return raw.toString();
    }

    private String getConfigLocation() {
        return this.replaceSlashes(this.configLocation.getAbsolutePath());
    }

    private String replaceSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public void setConfigLocation(File configLocation) {
        this.configLocation = configLocation;
    }
}

