/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.io;

import com.dahuatech.hutool.core.io.FileUtil;
import com.dahuatech.hutool.core.io.IORuntimeException;
import com.dahuatech.hutool.core.io.IoUtil;
import com.dahuatech.hutool.core.util.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileTypeUtil {
    private static final Map<String, String> fileTypeMap = new ConcurrentHashMap<String, String>();

    public static String putFileType(String fileStreamHexHead, String extName) {
        return fileTypeMap.put(fileStreamHexHead.toLowerCase(), extName);
    }

    public static String removeFileType(String fileStreamHexHead) {
        return fileTypeMap.remove(fileStreamHexHead.toLowerCase());
    }

    public static String getType(String fileStreamHexHead) {
        for (Map.Entry<String, String> fileTypeEntry : fileTypeMap.entrySet()) {
            if (!StrUtil.startWithIgnoreCase(fileStreamHexHead, fileTypeEntry.getKey())) continue;
            return fileTypeEntry.getValue();
        }
        return null;
    }

    public static String getType(InputStream in) throws IORuntimeException {
        return FileTypeUtil.getType(IoUtil.readHex28Upper(in));
    }

    public static String getType(File file) throws IORuntimeException {
        FileInputStream in = null;
        try {
            in = IoUtil.toStream(file);
            String string = FileTypeUtil.getType(in);
            return string;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static String getTypeByPath(String path) throws IORuntimeException {
        return FileTypeUtil.getType(FileUtil.file(path));
    }

    static {
        fileTypeMap.put("ffd8ff", "jpg");
        fileTypeMap.put("89504e47", "png");
        fileTypeMap.put("4749463837", "gif");
        fileTypeMap.put("4749463839", "gif");
        fileTypeMap.put("49492a00227105008037", "tif");
        fileTypeMap.put("424d228c010000000000", "bmp");
        fileTypeMap.put("424d8240090000000000", "bmp");
        fileTypeMap.put("424d8e1b030000000000", "bmp");
        fileTypeMap.put("41433130313500000000", "dwg");
        fileTypeMap.put("7b5c727466315c616e73", "rtf");
        fileTypeMap.put("38425053000100000000", "psd");
        fileTypeMap.put("46726f6d3a203d3f6762", "eml");
        fileTypeMap.put("d0cf11e0a1b11ae10000", "doc");
        fileTypeMap.put("5374616E64617264204A", "mdb");
        fileTypeMap.put("252150532D41646F6265", "ps");
        fileTypeMap.put("255044462d312e", "pdf");
        fileTypeMap.put("2e524d46000000120001", "rmvb");
        fileTypeMap.put("464c5601050000000900", "flv");
        fileTypeMap.put("00000020667479706d70", "mp4");
        fileTypeMap.put("49443303000000002176", "mp3");
        fileTypeMap.put("000001ba210001000180", "mpg");
        fileTypeMap.put("3026b2758e66cf11a6d9", "wmv");
        fileTypeMap.put("52494646e27807005741", "wav");
        fileTypeMap.put("52494646d07d60074156", "avi");
        fileTypeMap.put("4d546864000000060001", "mid");
        fileTypeMap.put("526172211a0700cf9073", "rar");
        fileTypeMap.put("235468697320636f6e66", "ini");
        fileTypeMap.put("504B03040a0000000000", "jar");
        fileTypeMap.put("504B0304140008000800", "jar");
        fileTypeMap.put("D0CF11E0A1B11AE10", "xls");
        fileTypeMap.put("504B0304", "zip");
        fileTypeMap.put("4d5a9000030000000400", "exe");
        fileTypeMap.put("3c25402070616765206c", "jsp");
        fileTypeMap.put("4d616e69666573742d56", "mf");
        fileTypeMap.put("7061636b616765207765", "java");
        fileTypeMap.put("406563686f206f66660d", "bat");
        fileTypeMap.put("1f8b0800000000000000", "gz");
        fileTypeMap.put("cafebabe0000002e0041", "class");
        fileTypeMap.put("49545346030000006000", "chm");
        fileTypeMap.put("04000000010000001300", "mxp");
        fileTypeMap.put("6431303a637265617465", "torrent");
        fileTypeMap.put("6D6F6F76", "mov");
        fileTypeMap.put("FF575043", "wpd");
        fileTypeMap.put("CFAD12FEC5FD746F", "dbx");
        fileTypeMap.put("2142444E", "pst");
        fileTypeMap.put("AC9EBD8F", "qdf");
        fileTypeMap.put("E3828596", "pwl");
        fileTypeMap.put("2E7261FD", "ram");
    }
}

