/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user.visitor;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ListView;
import com.dada.smart.common.ResourceIds;
import com.dada.smart.common.Utils;
import com.dada.smart.user.R;
import com.dada.smart.user.event.Event;
import com.dada.smart.user.event.ViewEvent;
import com.dada.smart.user.event.ViewTreeChild;
import com.orhanobut.logger.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewMatcher {
    private Map<String, Integer> idCountMap;
    private SparseBooleanArray viewShowArray;
    private List<View> visitViews;
    private ResourceIds resourceIds;

    public ViewMatcher(ResourceIds resourceIds) {
        this.resourceIds = resourceIds;
        this.viewShowArray = new SparseBooleanArray();
    }

    public ViewEvent matches(View root, Event event, ListView recentListView, RecyclerView recentRecyclerView) {
        ViewEvent viewEvent;
        if (root instanceof ListView || root instanceof RecyclerView) {
            this.clearIdCountMap();
        }
        if ((viewEvent = event.isIdMatcher() ? this.idMatches(root, event, recentListView, recentRecyclerView) : this.pathMatches(root, event)) != null && event.getTypeId() == 4L) {
            int eventId = (int)event.getId();
            boolean isShow = this.viewShowArray.get(eventId);
            if (!isShow) {
                this.viewShowArray.append(eventId, true);
            } else {
                viewEvent = null;
            }
        }
        return viewEvent;
    }

    private ViewEvent pathMatches(View root, Event event) {
        List<ViewTreeChild> list = event.getViewTreeChildren();
        int viewTreeLevel = (Integer)root.getTag(R.id.tag_tree_index);
        ViewParent parent = root.getParent();
        if (parent != null) {
            if (parent instanceof ViewGroup) {
                if (viewTreeLevel < list.size()) {
                    ViewTreeChild child = list.get(viewTreeLevel);
                    int childCount = ((ViewGroup)parent).getChildCount();
                    int index = ((ViewGroup)parent).indexOfChild(root);
                    if (TextUtils.equals((CharSequence)child.getClassName(), (CharSequence)Utils.simpleName((Object)root)) && childCount == child.getBrothersCount() && index == child.getIndex()) {
                        child.setPassVerify(true);
                    }
                }
            } else {
                list.get(0).setPassVerify(true);
            }
        }
        return event.checkAllTreeViewVerified() ? new ViewEvent(event, root) : null;
    }

    private ViewEvent idMatches(View root, Event event, ListView recentListView, RecyclerView recentRecyclerView) {
        boolean isMatch;
        String viewIdName = event.getViewIdName();
        String viewClassName = event.getViewClassName();
        if (viewClassName == null || viewIdName == null) {
            return null;
        }
        boolean bl = isMatch = viewIdName.equals(this.resourceIds.nameForId(root.getId())) && viewClassName.equals(Utils.canonicalName((Object)root));
        if (isMatch) {
            ViewEvent viewEvent = new ViewEvent(event, root);
            if (event.hasPos(R.id.tag_list_pos_index) && recentListView != null) {
                int pos = this.calculatePosition(recentListView.getFirstVisiblePosition(), this.countKey(recentListView.getId(), event.getId()));
                Logger.v((String)("ListView pos=" + pos), (Object[])new Object[0]);
                root.setTag(R.id.tag_list_pos_index, (Object)pos);
            } else if (event.hasPos(R.id.tag_recycler_pos_index) && recentRecyclerView != null) {
                RecyclerView.LayoutManager layoutManager = recentRecyclerView.getLayoutManager();
                if (layoutManager instanceof LinearLayoutManager) {
                    int pos = this.calculatePosition(((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition(), this.countKey(recentRecyclerView.getId(), event.getId()));
                    Logger.v((String)("RecyclerView pos=" + pos), (Object[])new Object[0]);
                    root.setTag(R.id.tag_recycler_pos_index, (Object)pos);
                }
            } else if (event.hasPos(R.id.tag_pos_index)) {
                int pos = this.getLinearPos(root);
                Logger.v((String)("LinearLayout.. pos=" + pos), (Object[])new Object[0]);
                root.setTag(R.id.tag_pos_index, (Object)pos);
            }
            return viewEvent;
        }
        return null;
    }

    private int getLinearPos(View root) {
        if (this.visitViews == null) {
            this.visitViews = new ArrayList<View>(2);
        }
        if (this.visitViews.contains(root)) {
            this.visitViews.clear();
        }
        int index = 0;
        for (View view : this.visitViews) {
            if (view.getId() != root.getId()) continue;
            ++index;
        }
        this.visitViews.add(root);
        return index;
    }

    private String countKey(int viewId, long eventId) {
        return viewId + "." + eventId;
    }

    private int calculatePosition(int firstVisiblePosition, String countKey) {
        if (this.idCountMap == null) {
            this.idCountMap = new HashMap<String, Integer>(2);
        }
        int count = 0;
        if (this.idCountMap.containsKey(countKey)) {
            count = this.idCountMap.get(countKey) + 1;
        }
        this.idCountMap.put(countKey, count);
        return firstVisiblePosition + count;
    }

    private void clearIdCountMap() {
        if (this.idCountMap != null) {
            this.idCountMap.clear();
        }
    }
}

