/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user.log;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.database.Cursor;
import com.dada.smart.user.log.Log;
import com.dada.smart.user.log.LogDao;
import java.util.ArrayList;
import java.util.List;

public class LogDao_Impl
implements LogDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfLog;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfLog;

    public LogDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfLog = new EntityInsertionAdapter<Log>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `Log`(`id`,`eventId`,`eventTypeId`,`refPageIdentifier`,`extra`,`triggerTime`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Log value) {
                stmt.bindLong(1, value.getId());
                stmt.bindLong(2, value.getEventId());
                stmt.bindLong(3, value.getEventTypeId());
                if (value.getRefPageIdentifier() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getRefPageIdentifier());
                }
                if (value.getExtra() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getExtra());
                }
                stmt.bindLong(6, value.getTriggerTime());
            }
        };
        this.__deletionAdapterOfLog = new EntityDeletionOrUpdateAdapter<Log>(__db){

            public String createQuery() {
                return "DELETE FROM `Log` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Log value) {
                stmt.bindLong(1, value.getId());
            }
        };
    }

    @Override
    public void insert(Log log) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfLog.insert((Object)log);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<Log> logs) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfLog.handleMultiple(logs);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Log> get(int limit) {
        String _sql = "SELECT * FROM log ORDER BY id DESC LIMIT ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM log ORDER BY id DESC LIMIT ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)limit);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfEventId = _cursor.getColumnIndexOrThrow("eventId");
            int _cursorIndexOfEventTypeId = _cursor.getColumnIndexOrThrow("eventTypeId");
            int _cursorIndexOfRefPageIdentifier = _cursor.getColumnIndexOrThrow("refPageIdentifier");
            int _cursorIndexOfExtra = _cursor.getColumnIndexOrThrow("extra");
            int _cursorIndexOfTriggerTime = _cursor.getColumnIndexOrThrow("triggerTime");
            ArrayList<Log> _result = new ArrayList<Log>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Log _item = new Log();
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                _item.setId(_tmpId);
                long _tmpEventId = _cursor.getLong(_cursorIndexOfEventId);
                _item.setEventId(_tmpEventId);
                long _tmpEventTypeId = _cursor.getLong(_cursorIndexOfEventTypeId);
                _item.setEventTypeId(_tmpEventTypeId);
                String _tmpRefPageIdentifier = _cursor.getString(_cursorIndexOfRefPageIdentifier);
                _item.setRefPageIdentifier(_tmpRefPageIdentifier);
                String _tmpExtra = _cursor.getString(_cursorIndexOfExtra);
                _item.setExtra(_tmpExtra);
                long _tmpTriggerTime = _cursor.getLong(_cursorIndexOfTriggerTime);
                _item.setTriggerTime(_tmpTriggerTime);
                _result.add(_item);
            }
            ArrayList<Log> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

