/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user.config;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Event {
    public static final long TYPE_CLICK = 1L;
    public static final long TYPE_PV = 2L;
    public static final long TYPE_APP_START = -1L;
    private long id;
    private long typeId;
    private String viewIdName;
    private String viewClassName;
    private List<ViewTreeChild> viewTreeChildren = new ArrayList<ViewTreeChild>();
    private boolean inMainWindow = true;
    private String expressions;

    public static Event fromJson(JSONObject object) throws JSONException {
        Event event = new Event();
        event.id = object.getLong("id");
        event.typeId = object.getLong("typeId");
        event.expressions = object.optString("expressions");
        String widgetIdentifier = object.getString("widgetIdentifier");
        Event.parseWidgetIdentifier(event, widgetIdentifier);
        return event;
    }

    private static void parseWidgetIdentifier(Event event, String widgetIdentifier) {
        String[] ss;
        boolean noId = false;
        if (widgetIdentifier.contains("@") && (ss = widgetIdentifier.split("@")).length >= 2) {
            String[] typeContent;
            String pre = ss[0];
            if (pre.contains(",") && (typeContent = pre.split(",")).length >= 2) {
                event.inMainWindow = TextUtils.equals((CharSequence)typeContent[0], (CharSequence)"1");
                noId = TextUtils.equals((CharSequence)typeContent[1], (CharSequence)"2");
            }
            widgetIdentifier = ss[1];
        }
        if (noId || widgetIdentifier.contains(";")) {
            String[] viewTrees = widgetIdentifier.split(";");
            if (viewTrees.length > 0) {
                for (String viewTree : viewTrees) {
                    String[] viewTressDesc = viewTree.split(",");
                    if (viewTressDesc.length != 3) continue;
                    ViewTreeChild child = new ViewTreeChild();
                    child.className = viewTressDesc[0];
                    try {
                        child.brothersCount = Integer.parseInt(viewTressDesc[1]);
                        child.index = Integer.parseInt(viewTressDesc[2]);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    event.viewTreeChildren.add(child);
                }
            }
        } else {
            String[] array = widgetIdentifier.split(",");
            if (array.length >= 2) {
                event.viewClassName = array[0];
                event.viewIdName = array[1];
            }
        }
    }

    public boolean isInMainWindow() {
        return this.inMainWindow;
    }

    public void setInMainWindow(boolean inMainWindow) {
        this.inMainWindow = inMainWindow;
    }

    public long getId() {
        return this.id;
    }

    public long getTypeId() {
        return this.typeId;
    }

    public String getViewIdName() {
        return this.viewIdName;
    }

    public String getViewClassName() {
        return this.viewClassName;
    }

    public void setId(long id2) {
        this.id = id2;
    }

    public void setTypeId(long typeId) {
        this.typeId = typeId;
    }

    public void setViewIdName(String viewIdName) {
        this.viewIdName = viewIdName;
    }

    public void setViewClassName(String viewClassName) {
        this.viewClassName = viewClassName;
    }

    public String getExpressions() {
        return this.expressions;
    }

    public void setExpressions(String expressions) {
        this.expressions = expressions;
    }

    public List<ViewTreeChild> getViewTreeChildren() {
        return this.viewTreeChildren;
    }

    public void setViewTreeChildren(List<ViewTreeChild> viewTreeChildren) {
        this.viewTreeChildren = viewTreeChildren;
    }

    public String toString() {
        return "id:" + this.id + " typeId:" + this.typeId + " viewIdPath:" + this.viewIdName + " viewClassName:" + this.viewClassName + " expressions:" + this.expressions;
    }

    public boolean checkAllTreeViewVerified() {
        if (this.viewTreeChildren.isEmpty()) {
            return false;
        }
        for (ViewTreeChild child : this.viewTreeChildren) {
            if (child.isPassVerify()) continue;
            return false;
        }
        return true;
    }

    public static class ViewTreeChild {
        String className;
        int brothersCount;
        int index;
        boolean passVerify;

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public int getBrothersCount() {
            return this.brothersCount;
        }

        public void setBrothersCount(int brothersCount) {
            this.brothersCount = brothersCount;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isPassVerify() {
            return this.passVerify;
        }

        public void setPassVerify(boolean passVerify) {
            this.passVerify = passVerify;
        }
    }
}

