/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user;

import android.app.Activity;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.dada.smart.common.ResourceIds;
import com.dada.smart.common.Utils;
import com.dada.smart.common.WindowMagician;
import com.dada.smart.user.EventLogRepository;
import com.dada.smart.user.config.ClickEvents;
import com.dada.smart.user.config.Event;
import com.orhanobut.logger.Logger;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ViewVisitor {
    private ResourceIds resourceIds;
    private OnEventListener listener;
    private Map<View, AccessibilityDelegate> delegateMap;
    private Executor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(64), new ThreadPoolExecutor.DiscardOldestPolicy());
    private ClickEvents clickEvents;
    private List<Event> events;
    private WeakReference<Activity> weakReference;
    private EventLogRepository eventLogRepository;
    private String activityName;

    public ViewVisitor(ResourceIds resourceIds, Activity activity, EventLogRepository eventLogRepository, OnEventListener listener) {
        this.resourceIds = resourceIds;
        this.weakReference = new WeakReference<Activity>(activity);
        this.clickEvents = eventLogRepository.getEvents(Utils.canonicalName((Object)activity));
        if (this.clickEvents != null) {
            this.events = this.clickEvents.getEvents();
        } else {
            this.eventLogRepository = eventLogRepository;
            this.activityName = Utils.canonicalName((Object)activity);
        }
        this.listener = listener;
        this.delegateMap = new HashMap<View, AccessibilityDelegate>();
    }

    public void bindEvents() {
        if ((this.events == null || this.events.isEmpty()) && this.eventLogRepository != null && !TextUtils.isEmpty((CharSequence)this.activityName)) {
            this.clickEvents = this.eventLogRepository.getEvents(Utils.canonicalName((Object)this.activityName));
            if (this.clickEvents != null) {
                this.events = this.clickEvents.getEvents();
            }
        }
        if (this.events != null && !this.events.isEmpty()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Activity activity = (Activity)ViewVisitor.this.weakReference.get();
                    if (activity != null) {
                        ViewVisitor.this.delegateMap.clear();
                        if (ViewVisitor.this.clickEvents.isInMainWindow()) {
                            ViewVisitor.this.bindEventToTargetView(activity.getWindow().getDecorView(), ViewVisitor.this.events, 0);
                        } else {
                            List list = WindowMagician.getFocusWindowRootView((Activity)activity);
                            for (WindowMagician.ViewRootData viewRootData : list) {
                                ViewVisitor.this.bindEventToTargetView(viewRootData.getView(), ViewVisitor.this.events, 0);
                            }
                        }
                    }
                }
            });
        }
    }

    @VisibleForTesting
    public Map<View, AccessibilityDelegate> getDelegateMap() {
        return this.delegateMap;
    }

    private void bindEventToTargetView(View root, List<Event> events, int viewTreeLevel) {
        if (root == null) {
            return;
        }
        for (Event event : events) {
            if (!this.matches(root, event, viewTreeLevel)) continue;
            Logger.v((String)("find view=" + root + " event" + event), (Object[])new Object[0]);
            this.addEventToAccessibilityDelegate(root, event);
        }
        if (root instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)root;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                this.bindEventToTargetView(parent.getChildAt(i), events, viewTreeLevel + 1);
            }
        }
    }

    private void addEventToAccessibilityDelegate(View root, Event event) {
        AccessibilityDelegate delegate = this.delegateMap.get(root);
        if (delegate == null) {
            delegate = new AccessibilityDelegate();
            root.setAccessibilityDelegate((View.AccessibilityDelegate)delegate);
            this.delegateMap.put(root, delegate);
        }
        delegate.addEvent(event);
    }

    private boolean matches(View root, Event event, int viewTreeLevel) {
        List<Event.ViewTreeChild> list = event.getViewTreeChildren();
        if (list.isEmpty()) {
            String viewIdName = event.getViewIdName();
            String viewClassName = event.getViewClassName();
            if (viewClassName == null || viewIdName == null) {
                return false;
            }
            return viewIdName.equals(this.resourceIds.nameForId(root.getId())) && viewClassName.equals(Utils.canonicalName((Object)root));
        }
        ViewParent parent = root.getParent();
        if (parent != null) {
            if (parent instanceof ViewGroup) {
                if (viewTreeLevel < list.size()) {
                    Event.ViewTreeChild child = list.get(viewTreeLevel);
                    int childCount = ((ViewGroup)parent).getChildCount();
                    int index = ((ViewGroup)parent).indexOfChild(root);
                    if (TextUtils.equals((CharSequence)child.getClassName(), (CharSequence)Utils.simpleName((Object)root)) && childCount == child.getBrothersCount() && index == child.getIndex()) {
                        child.setPassVerify(true);
                    }
                }
            } else {
                list.get(0).setPassVerify(true);
            }
        }
        return event.checkAllTreeViewVerified();
    }

    @VisibleForTesting
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    private class AccessibilityDelegate
    extends View.AccessibilityDelegate {
        List<Event> events = new CopyOnWriteArrayList<Event>();

        public void addEvent(Event event) {
            this.events.add(event);
        }

        public void sendAccessibilityEvent(View host, int eventType) {
            if (ViewVisitor.this.listener == null) {
                return;
            }
            for (Event event : this.events) {
                if (!this.matchEvent(event, eventType)) continue;
                ViewVisitor.this.listener.onEvent(event);
            }
        }

        boolean matchEvent(Event event, int eventType) {
            return 1L == event.getTypeId() && eventType == 1;
        }
    }

    public static interface OnEventListener {
        public void onEvent(Event var1);
    }
}

