/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.user.http;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.dada.smart.user.http.Client;
import com.dada.smart.user.http.HttpRequest;
import com.orhanobut.logger.Logger;
import java.util.Map;
import org.json.JSONObject;

public class CacheHttpClient
implements Client {
    private SharedPreferences sp;

    public CacheHttpClient(@NonNull SharedPreferences sp) {
        this.sp = sp;
    }

    @Override
    public Client.Call makeCall(final Client.Method method, final String url, final Map<String, ?> param) {
        return new Client.Call(){

            @Override
            public String execute() {
                String result = "";
                try {
                    switch (method) {
                        case GET: {
                            Logger.v((String)((Object)((Object)method) + " request:" + url + ":" + param), (Object[])new Object[0]);
                            result = CacheHttpClient.this.get(url, param);
                            break;
                        }
                        case POST: {
                            JSONObject body = new JSONObject(param);
                            Logger.v((String)((Object)((Object)method) + " request:" + url + ":" + body), (Object[])new Object[0]);
                            result = HttpRequest.post(url).contentType("application/json").send(body.toString()).body();
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Logger.v((String)((Object)((Object)method) + " response:" + url + "" + result), (Object[])new Object[0]);
                return result;
            }

            @Override
            public String cache() {
                return CacheHttpClient.this.sp.getString(CacheHttpClient.this.cacheKey(url, param), "");
            }
        };
    }

    private String cacheKey(String url, Map<String, ?> param) {
        return url + new JSONObject(param).toString();
    }

    private String get(String url, Map<String, ?> param) {
        String result = "";
        String cacheKey = this.cacheKey(url, param);
        try {
            result = HttpRequest.get((CharSequence)url, param, false).connectTimeout(3000).readTimeout(5000).body();
            this.sp.edit().putString(cacheKey, result).commit();
        }
        catch (HttpRequest.HttpRequestException e) {
            e.printStackTrace();
        }
        return result;
    }
}

