package com.dada.smart.user.visitor;

import android.app.Activity;
import android.support.annotation.NonNull;

import com.dada.smart.common.ResourceIds;
import com.dada.smart.common.Utils;
import com.dada.smart.user.event.Event;
import com.dada.smart.user.event.Events;
import com.dada.smart.user.event.ViewEvent;
import com.dada.smart.user.event.ViewEventListener;

import java.util.List;

/**
 * 处理跟Activity生命周期相关的事件
 */
public class ActivityVisitor {

    private ViewEventListener listener;
    private List<Event> pvEvents;
    private ViewVisitor viewVisitor;

    public ActivityVisitor(@NonNull Activity activity,
                           @NonNull Events viewEvents,
                           @NonNull List<Event> pvEvents,
                           @NonNull ViewEventListener listener,
                           @NonNull ResourceIds resourceIds) {
        this.listener = listener;
        this.pvEvents = pvEvents;
        if (viewEvents != null) {
            this.viewVisitor = new ViewVisitor(activity, resourceIds, viewEvents,
                    listener);
        }
    }

    /**
     * activity#onCreate
     */
    public void onCreate() {
        triggerPvEventIfSet(Event.TYPE_PV_START);

        if (viewVisitor != null) {
            viewVisitor.onCreate();
        }
    }

    /**
     * activity#onDestroy
     */
    public void onDestroy() {
        triggerPvEventIfSet(Event.TYPE_PV_END);

        if (viewVisitor != null) {
            viewVisitor.onDestroy();
            viewVisitor = null;
        }
    }


    /**
     * 如果配置过页面打开、关闭事件，则触发相应事件
     *
     * @param typeId
     */
    private void triggerPvEventIfSet(long typeId) {
        if (!Utils.isEmpty(pvEvents)) {
            for (Event event : pvEvents) {
                if (event.getTypeId() == typeId)
                    listener.onEvent(new ViewEvent(event, null));
            }
        }
    }

}
