package com.dada.response.watcher.entity;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by whh on 2019/6/20
 */
public class NetStatus {
    private long time;
    private Tag tags;
    private List<Metric> metrics = new ArrayList<>();

    public NetStatus(long time, Tag tags, List<Metric> metrics) {
        this.time = time;
        this.tags = tags;
        this.metrics = metrics;
    }

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Tag getTags() {
        return tags;
    }

    public void setTags(Tag tags) {
        this.tags = tags;
    }

    public List<Metric> getMetrics() {
        return metrics;
    }

    public void setMetrics(List<Metric> metrics) {
        synchronized (this) {
            this.metrics = metrics;
        }
    }

    public static class Metric {
        public String name = "app_access";
        private Tag tags;
        private Fields fields;

        public Metric(Tag tags, Fields fields) {
            this.tags = tags;
            this.fields = fields;
        }

        public Tag getTags() {
            return tags;
        }

        public void setTags(Tag tags) {
            this.tags = tags;
        }

        public Fields getFields() {
            return fields;
        }

        public void setFields(Fields fields) {
            this.fields = fields;
        }

        public static class Fields {
            private long count;

            public Fields(long count) {
                this.count = count;
            }

            public long getCount() {
                return count;
            }

            public void setCount(int count) {
                this.count = count;
            }
        }

        public static class Tag {
            private String domain;
            private String uri;
            private int status;

            public Tag(String domain, String uri, int status) {
                this.domain = domain;
                this.uri = uri;
                this.status = status;
            }

            public String getDomain() {
                return domain;
            }

            public void setDomain(String domain) {
                this.domain = domain;
            }

            public String getUri() {
                return uri;
            }

            public void setUri(String uri) {
                this.uri = uri;
            }

            public int getStatus() {
                return status;
            }

            public void setStatus(int status) {
                this.status = status;
            }
        }
    }

    public static class Tag {
        private String app = "";
        public String device = "android";
        private String city = "0";
        private String deviceId = "";
        private String network = "";
        private String operator = "";

        public Tag(String app,  String city, String deviceId, String network, String operator) {
            this.app = app;
            this.city = city;
            this.deviceId = deviceId;
            this.network = network;
            this.operator = operator;
        }

        public String getApp() {
            return app;
        }

        public void setApp(String app) {
            this.app = app;
        }

        public String getCity() {
            return city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getDeviceId() {
            return deviceId;
        }

        public void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public String getNetwork() {
            return network;
        }

        public void setNetwork(String network) {
            this.network = network;
        }

        public String getOperator() {
            return operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}
