package com.dada.response.watcher.watcher;


import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import com.dada.response.watcher.ResponseWatchUtil;
import com.alibaba.fastjson.JSON;
import com.dada.response.watcher.entity.NetStatus;
import com.dada.response.watcher.entity.NetStatusCache;
import com.dada.response.watcher.entity.NetStatusCache.NetStatusZip;
import com.dada.response.watcher.http.pojo.ResponseBody;
import com.dada.response.watcher.inter.TagInterface;
import com.dada.response.watcher.util.ArrayUtils;
import com.dada.response.watcher.util.ResponseWatchDebug;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

import retrofit2.Response;

/**
 * Created by whh on 2019/5/31
 */
public class ResponseHelper {

    public static final String TAG = "ResponseHelper";
    private static final String SPF_RESPONSE_REPOSITORY = "spf_response_repository";
    private static final String SPF_NETSTATUS = "netstatus";


    private static ResponseHelper instance;
    private NetStatusCache netStatus;
    private SharedPreferences netStatusPre;

    private Executor executor = Executors.newSingleThreadExecutor();
    private TagInterface tagInterface;

    public static ResponseHelper getInstance() {
        if (instance == null) {
            instance = new ResponseHelper();
        }
        return instance;
    }

    private ResponseHelper() {
        netStatusPre = ResponseWatchUtil.getContext().getSharedPreferences(SPF_RESPONSE_REPOSITORY, Context.MODE_PRIVATE);
        String netStatusStr = netStatusPre.getString(SPF_NETSTATUS, "");
        if (!TextUtils.isEmpty(netStatusStr)) {
            //同步数据
            try {
                netStatus = JSON.parseObject(netStatusStr, NetStatusCache.class);
                ResponseWatchDebug.d(TAG, "netStatus  " + netStatus.toString());
            } catch (Exception e) {
                ResponseWatchDebug.d(TAG, "SharedPreferences 1  " + e.getMessage());
                netStatus = new NetStatusCache();
            }
        } else {
            ResponseWatchDebug.d(TAG, "SharedPreferences new NetStatusCache");
            netStatus = new NetStatusCache();
        }
    }

    public synchronized void addWatchedData(String domain, String uri, int status) {
        //使用压缩的数据类型，不能对 netStatus 加锁，因为在上传的时候需要对 netStatus 仍然是可以进行写入的
        final List<NetStatusZip> zipList = netStatus.getStatusList();
        String key = String.format(Locale.CHINA, "%s;%s;%d", domain, uri, status);
        for (int i = 0; i < zipList.size(); i++) {
            NetStatusZip netStatusZip = zipList.get(i);
            if (null == netStatusZip)
                continue;
            if (key.equals(netStatusZip.getKey())) {
                int count = netStatusZip.getCount();
                count++;
                netStatusZip.setCount(count);
                syncSharedPreferences();
                return;
            }
        }

        //size =0 或 找了一圈，发现都没有添加过，就添加一个新的
        zipList.add(new NetStatusZip(key, 1));
        syncSharedPreferences();
    }

    void saveAndUpload() {
        try {
            sendResponseLog();
        } catch (Exception e) {
            e.printStackTrace();
            ResponseWatchDebug.d(TAG, "db save exception: " + e.getMessage());
        }
    }

    private synchronized void sendResponseLog() throws Exception {
        NetStatus netStatusToUpload = unZipNetStatus();

        ResponseWatchDebug.d(TAG, "转换完类型");

        if (null == netStatusToUpload || ArrayUtils.isEmpty(netStatusToUpload.getMetrics()))
            return;

        NetStatusCache netStatusCopy = (NetStatusCache) netStatus.clone();

        ResponseWatchDebug.d(TAG, "真正开始发送");
        Response<ResponseBody> response = ResponseApi
                .getClientApi()
                .collectMetrics(netStatusToUpload)
                .execute();

        //测试代码
        //        Thread.sleep(5000);

        ResponseBody responseBody = response.body();
        if (null != responseBody && responseBody.isOk()) {
            ResponseWatchDebug.d(TAG, "返回了我们的 Response");
            //清空
            resetNetStatusCache(netStatusCopy);
        } else {
            if (null != responseBody) {
                ResponseWatchDebug.d(TAG, "失败 code " + responseBody.getErrorCode() + " message" + responseBody.getErrorMsg());
            } else {
                ResponseWatchDebug.d(TAG, "网络不通");
            }
        }
    }

    public void setTagInterface(TagInterface tagInterface) {
        this.tagInterface = tagInterface;
    }

    //解压 NetStatus
    private NetStatus unZipNetStatus() {

        List<NetStatusZip> netStatusZips = netStatus.getStatusList();
        if (ArrayUtils.isEmpty(netStatusZips)) {
            return null;
        }

        NetStatus netStatus = new NetStatus();
        netStatus.setTime(System.currentTimeMillis());
        netStatus.getTags().setApp(tagInterface.getAppName());
        netStatus.getTags().setCity(tagInterface.getCityCode());
        netStatus.getTags().setDeviceId(tagInterface.getDeviceId());
        netStatus.getTags().setNetwork(tagInterface.getNetWork());
        netStatus.getTags().setOperator(tagInterface.getOperator());

        List<NetStatus.Metric> metrics = netStatus.getMetrics();
        for (int i = 0; i < netStatusZips.size(); i++) {
            int count = netStatusZips.get(i).getCount();
            //过滤掉 0 的数据
            if (0 == count)
                continue;

            String[] keyValue = netStatusZips.get(i).getKey().split(";");
            if (keyValue.length < 3)
                continue;

            String domain = keyValue[0];
            String uri = keyValue[1];
            int status = Integer.valueOf(keyValue[2]);
            NetStatus.Metric.Fields fields = new NetStatus.Metric.Fields(count);
            NetStatus.Metric.Tag tags = new NetStatus.Metric.Tag(domain, uri, status);
            NetStatus.Metric metric = new NetStatus.Metric(tags, fields);
            metrics.add(metric);
        }

        return netStatus;
    }

    /**
     * 使用 netStatusCopy 重置内存中的 netStatus
     */
    private void resetNetStatusCache(NetStatusCache netStatusCopy) {
        if (null == netStatusCopy || ArrayUtils.isEmpty(netStatusCopy.getStatusList())) {
            return;
        }

        List<NetStatusZip> netStatusZipsCopy = netStatusCopy.getStatusList();
        List<NetStatusZip> netStatusZipsCache = netStatus.getStatusList();

        for (int i = 0; i < netStatusZipsCopy.size(); i++) {
            for (int j = 0; j < netStatusZipsCache.size(); j++) {
                NetStatusZip netStatusZip = netStatusZipsCache.get(j);
                NetStatusZip netStatusZipC = netStatusZipsCopy.get(j);
                if (null == netStatusZip || null == netStatusZipC)
                    continue;
                if (netStatusZip.equals(netStatusZipsCopy.get(i))) {
                    netStatusZip.setCount(netStatusZip.getCount() - netStatusZipC.getCount());
                }
            }
        }
        syncSharedPreferences();
    }

    /**
     * 将内存中的 netStatus 同步到缓存中
     * 缓存时机：netStatus 改变的时候，也就是所有 netStatus 修改的时候进行同步
     */
    private synchronized void syncSharedPreferences() {
        executor.execute(() -> {
            try {
                netStatusPre.edit().putString(SPF_NETSTATUS, JSON.toJSONString(netStatus)).apply();
            } catch (Exception e) {
                ResponseWatchDebug.d(TAG, "SharedPreferences save exception: " + e.getMessage());
            }
        });
    }
}
