package com.dada.response.watcher.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Created by whh on 2019/5/31
 */

public class NetStatusCache implements Cloneable {
    
    private List<NetStatusZip> statusList = new ArrayList<>();

    public List<NetStatusZip> getStatusList() {
        return statusList;
    }

    public void setStatusList(List<NetStatusZip> statusList) {
        this.statusList = statusList;
    }

    public void addStatusArray(NetStatusZip netStatusZip) {
        statusList.add(netStatusZip);
    }

    public static class NetStatusZip implements Cloneable {
        private String key = ""; //key 的格式为 url
        private int count = 0;

        public NetStatusZip() {
        }

        public NetStatusZip(String key, int count) {
            this.key = key;
            this.count = count;
        }

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public int getCount() {
            return count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        @Override
        public Object clone() {
            NetStatusZip clone = null;
            try {
                clone = (NetStatusZip) super.clone();
            } catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            return clone;
        }

        @Override
        public String toString() {
            return "NetStatusZip [key=" + key + ", count=" + count + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
                return false;

            NetStatusZip that = (NetStatusZip) o;

            if (key != null ? !key.equals(that.key) : that.key != null)
                return false;
            return count == that.count;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NetStatusCache statusCache = (NetStatusCache) super.clone();
        List<NetStatusZip> statusZips = new ArrayList<>();
        Iterator<NetStatusZip> iterator = statusList.iterator();
        while (iterator.hasNext()) {
            statusZips.add((NetStatusZip) iterator.next().clone());
        }
        statusCache.statusList = statusZips;
        return statusCache;
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < statusList.size(); i++) {
            output.append("NetStatusCache [statusList ").append(i).append(" = ").append(statusList.get(i).toString()).append("]\n");

        }
        return output.toString();
    }
}
