/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins;

import com.dabsquared.gitlabjenkins.GitLabMergeCause;
import com.dabsquared.gitlabjenkins.GitLabMergeRequest;
import com.dabsquared.gitlabjenkins.GitLabPushCause;
import com.dabsquared.gitlabjenkins.GitLabPushRequest;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.plugins.git.RevisionParameterAction;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.SequentialExecutionQueue;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitLabPushTrigger
extends Trigger<AbstractProject<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(GitLabPushTrigger.class.getName());

    @DataBoundConstructor
    public GitLabPushTrigger() {
    }

    public void onPost(final GitLabPushRequest req) {
        this.getDescriptor().queue.execute(new Runnable(){

            public void run() {
                LOGGER.log(Level.INFO, "{0} triggered.", ((AbstractProject)GitLabPushTrigger.this.job).getName());
                String name = " #" + ((AbstractProject)GitLabPushTrigger.this.job).getNextBuildNumber();
                GitLabPushCause cause = this.createGitLabPushCause(req);
                Action[] actions = this.createActions(req);
                if (((AbstractProject)GitLabPushTrigger.this.job).scheduleBuild(((AbstractProject)GitLabPushTrigger.this.job).getQuietPeriod(), (Cause)cause, actions)) {
                    LOGGER.log(Level.INFO, "GitLab Push Request detected in {0}. Triggering {1}", new String[]{((AbstractProject)GitLabPushTrigger.this.job).getName(), name});
                } else {
                    LOGGER.log(Level.INFO, "GitLab Push Request detected in {0}. Job is already in the queue.", ((AbstractProject)GitLabPushTrigger.this.job).getName());
                }
            }

            private GitLabPushCause createGitLabPushCause(GitLabPushRequest req2) {
                GitLabPushCause cause;
                String triggeredByUser = req2.getCommits().get(0).getAuthor().getName();
                try {
                    cause = new GitLabPushCause(triggeredByUser, GitLabPushTrigger.this.getLogFile());
                }
                catch (IOException ex) {
                    cause = new GitLabPushCause(triggeredByUser);
                }
                return cause;
            }

            private Action[] createActions(GitLabPushRequest req2) {
                ArrayList<Object> actions = new ArrayList<Object>();
                String branch = req2.getRef().replaceAll("refs/heads/", "");
                LOGGER.log(Level.INFO, "GitLab Push Request from branch {0}.", branch);
                HashMap<String, StringParameterValue> values = new HashMap<String, StringParameterValue>();
                values.put("gitlabSourceBranch", new StringParameterValue("gitlabSourceBranch", branch));
                values.put("gitlabTargetBranch", new StringParameterValue("gitlabTargetBranch", branch));
                values.put("gitlabBranch", new StringParameterValue("gitlabBranch", branch));
                ArrayList listValues = new ArrayList(values.values());
                ParametersAction parametersAction = new ParametersAction(listValues);
                actions.add(parametersAction);
                RevisionParameterAction revision = new RevisionParameterAction(req2.getLastCommit().getId());
                actions.add(revision);
                Action[] actionsArray = actions.toArray(new Action[0]);
                return actionsArray;
            }
        });
    }

    public void onPost(final GitLabMergeRequest req) {
        this.getDescriptor().queue.execute(new Runnable(){

            public void run() {
                LOGGER.log(Level.INFO, "{0} triggered.", ((AbstractProject)GitLabPushTrigger.this.job).getName());
                String name = " #" + ((AbstractProject)GitLabPushTrigger.this.job).getNextBuildNumber();
                GitLabMergeCause cause = this.createGitLabMergeCause(req);
                Action[] actions = this.createActions(req);
                if (((AbstractProject)GitLabPushTrigger.this.job).scheduleBuild(((AbstractProject)GitLabPushTrigger.this.job).getQuietPeriod(), (Cause)cause, actions)) {
                    LOGGER.log(Level.INFO, "GitLab Merge Request detected in {0}. Triggering {1}", new String[]{((AbstractProject)GitLabPushTrigger.this.job).getName(), name});
                } else {
                    LOGGER.log(Level.INFO, "GitLab Merge Request detected in {0}. Job is already in the queue.", ((AbstractProject)GitLabPushTrigger.this.job).getName());
                }
            }

            private GitLabMergeCause createGitLabMergeCause(GitLabMergeRequest req2) {
                GitLabMergeCause cause;
                try {
                    cause = new GitLabMergeCause(req2, GitLabPushTrigger.this.getLogFile());
                }
                catch (IOException ex) {
                    cause = new GitLabMergeCause(req2);
                }
                return cause;
            }

            private Action[] createActions(GitLabMergeRequest req2) {
                ArrayList<ParametersAction> actions = new ArrayList<ParametersAction>();
                HashMap<String, StringParameterValue> values = new HashMap<String, StringParameterValue>();
                values.put("gitlabSourceBranch", new StringParameterValue("gitlabSourceBranch", String.valueOf(req2.getObjectAttribute().getSourceBranch())));
                values.put("gitlabTargetBranch", new StringParameterValue("gitlabTargetBranch", String.valueOf(req2.getObjectAttribute().getTargetBranch())));
                ArrayList listValues = new ArrayList(values.values());
                ParametersAction parametersAction = new ParametersAction(listValues);
                actions.add(parametersAction);
                Action[] actionsArray = actions.toArray(new Action[0]);
                return actionsArray;
            }
        });
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.get();
    }

    public File getLogFile() {
        return new File(((AbstractProject)this.job).getRootDir(), "gitlab-polling.log");
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        AbstractProject project;
        private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Jenkins.MasterComputer.threadPoolForRemoting);

        public boolean isApplicable(Item item) {
            if (item instanceof AbstractProject) {
                this.project = (AbstractProject)item;
                return true;
            }
            return false;
        }

        public String getDisplayName() {
            if (this.project == null) {
                return "Build when a change is pushed to GitLab, unknown URL";
            }
            String projectURL = null;
            try {
                projectURL = URLEncoder.encode(this.project.getName(), "UTF-8");
                projectURL = projectURL.replace("+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                projectURL = this.project.getName();
            }
            return "Build when a change is pushed to GitLab. GitLab CI Service URL: " + Jenkins.getInstance().getRootUrl() + "project/" + projectURL;
        }

        public String getHelpFile() {
            return "/plugin/gitlab-jenkins/help/help-trigger.jelly";
        }

        public static DescriptorImpl get() {
            return (DescriptorImpl)((Object)Trigger.all().get(DescriptorImpl.class));
        }
    }
}

