/*
 * Decompiled with CFR 0.152.
 */
package com.bigbaozi.aspectjlibrary;

import android.util.Log;
import com.bigbaozi.aspectjlibrary.annotation.CountTime;
import com.bigbaozi.aspectjlibrary.interf.ICountTime;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class AspectJxTest {
    public static final String COUNT_TIME = "execution(@com.bigbaozi.aspectjlibrary.annotation.CountTime * *(..))";

    @Pointcut(value="execution(@com.bigbaozi.aspectjlibrary.annotation.CountTime * *(..))")
    public void DebugCountTime() {
    }

    @Around(value="DebugCountTime()")
    public void onDebugCountTimeMethodBefore(ProceedingJoinPoint joinPoint) throws Throwable {
        Object object = joinPoint.getThis();
        if (object == null) {
            return;
        }
        Class<?> aClass = object.getClass();
        Method[] methods = aClass.getMethods();
        if (methods == null || methods.length == 0) {
            return;
        }
        for (Method method : methods) {
            boolean annotationPresent = method.isAnnotationPresent(CountTime.class);
            if (!annotationPresent) continue;
            System.nanoTime();
            CountTime annotation = method.getAnnotation(CountTime.class);
            String[] value = annotation.value();
            String methodName = value[0];
            if (!joinPoint.getSignature().toString().endsWith(methodName + "()")) continue;
            long timeMillis = System.currentTimeMillis();
            joinPoint.proceed();
            long timeMillis2 = System.currentTimeMillis();
            ICountTime CTLister = (ICountTime)object;
            Log.e((String)"AAA", (String)("\u65b9\u6cd5" + methodName + "\u7684\u8017\u65f6\u95f4\u4e3a\uff1a" + (timeMillis2 - timeMillis) + "ms"));
            CTLister.GetTimes(methodName, timeMillis2 - timeMillis);
        }
    }
}

