/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.date;

import com.datastax.driver.core.CodecUtils;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class SimpleDateCodec
extends TypeCodec.PrimitiveIntCodec {
    public static final SimpleDateCodec instance = new SimpleDateCodec();
    private static final String pattern = "yyyy-MM-dd";

    public SimpleDateCodec() {
        super(DataType.date());
    }

    @Override
    public ByteBuffer serializeNoBoxing(int value, ProtocolVersion protocolVersion) {
        return SimpleDateCodec.cint().serializeNoBoxing(CodecUtils.fromSignedToUnsignedInt(value), protocolVersion);
    }

    @Override
    public int deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return 0;
        }
        return CodecUtils.fromUnsignedToSignedInt(SimpleDateCodec.cint().deserializeNoBoxing(bytes, protocolVersion));
    }

    @Override
    public Integer parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted(value)) {
            value = ParseUtils.unquote(value);
        }
        if (ParseUtils.isLongLiteral(value)) {
            long unsigned;
            try {
                unsigned = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value), e);
            }
            try {
                return CodecUtils.fromCqlDateToDaysSinceEpoch(unsigned);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value), e);
            }
        }
        try {
            Date date = ParseUtils.parseDate(value, pattern);
            return (int)TimeUnit.MILLISECONDS.toDays(date.getTime());
        }
        catch (ParseException e) {
            throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value), e);
        }
    }

    @Override
    public String format(Integer value) {
        if (value == null) {
            return "NULL";
        }
        long raw = CodecUtils.fromDaysSinceEpochToCqlDate(value);
        return ParseUtils.quote(Long.toString(raw));
    }
}

