/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.arrays;

import com.datastax.driver.core.CodecUtils;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.extras.codecs.arrays.AbstractArrayCodec;
import java.lang.reflect.Array;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ObjectArrayCodec<E>
extends AbstractArrayCodec<E[]> {
    protected final TypeCodec<E> eltCodec;

    public ObjectArrayCodec(DataType.CollectionType cqlType, Class<E[]> javaClass, TypeCodec<E> eltCodec) {
        super(cqlType, javaClass);
        this.eltCodec = eltCodec;
    }

    @Override
    public ByteBuffer serialize(E[] value, ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        int i = 0;
        ByteBuffer[] bbs = new ByteBuffer[value.length];
        for (E elt : value) {
            ByteBuffer bb;
            if (elt == null) {
                throw new NullPointerException("Collection elements cannot be null");
            }
            try {
                bb = this.eltCodec.serialize(elt, protocolVersion);
            }
            catch (ClassCastException e) {
                throw new InvalidTypeException(String.format("Invalid type for %s element, expecting %s but got %s", this.cqlType, this.eltCodec.getJavaType(), elt.getClass()), e);
            }
            bbs[i++] = bb;
        }
        return CodecUtils.pack(bbs, value.length, protocolVersion);
    }

    @Override
    public E[] deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return this.newInstance(0);
        }
        try {
            ByteBuffer input = bytes.duplicate();
            int n = CodecUtils.readSize(input, protocolVersion);
            E[] array = this.newInstance(n);
            for (int i = 0; i < n; ++i) {
                ByteBuffer databb = CodecUtils.readValue(input, protocolVersion);
                array[i] = this.eltCodec.deserialize(databb, protocolVersion);
            }
            return array;
        }
        catch (BufferUnderflowException e) {
            throw new InvalidTypeException("Not enough bytes to deserialize list");
        }
    }

    @Override
    protected void formatElement(StringBuilder output, E[] array, int index) {
        output.append(this.eltCodec.format(array[index]));
    }

    @Override
    protected void parseElement(String input, E[] array, int index) {
        array[index] = this.eltCodec.parse(input);
    }

    @Override
    protected E[] newInstance(int size) {
        return (Object[])Array.newInstance(this.getJavaType().getRawType().getComponentType(), size);
    }
}

