/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.ChainableLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class TokenAwarePolicy
implements ChainableLoadBalancingPolicy {
    private final LoadBalancingPolicy childPolicy;
    private final boolean shuffleReplicas;
    private volatile Metadata clusterMetadata;
    private volatile ProtocolVersion protocolVersion;
    private volatile CodecRegistry codecRegistry;

    public TokenAwarePolicy(LoadBalancingPolicy childPolicy, boolean shuffleReplicas) {
        this.childPolicy = childPolicy;
        this.shuffleReplicas = shuffleReplicas;
    }

    public TokenAwarePolicy(LoadBalancingPolicy childPolicy) {
        this(childPolicy, true);
    }

    @Override
    public LoadBalancingPolicy getChildPolicy() {
        return this.childPolicy;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.clusterMetadata = cluster.getMetadata();
        this.protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        this.codecRegistry = cluster.getConfiguration().getCodecRegistry();
        this.childPolicy.init(cluster, hosts);
    }

    @Override
    public HostDistance distance(Host host) {
        return this.childPolicy.distance(host);
    }

    @Override
    public Iterator<Host> newQueryPlan(final String loggedKeyspace, final Statement statement) {
        Iterator<Host> iter;
        ByteBuffer partitionKey = statement.getRoutingKey(this.protocolVersion, this.codecRegistry);
        String keyspace = statement.getKeyspace();
        if (keyspace == null) {
            keyspace = loggedKeyspace;
        }
        if (partitionKey == null || keyspace == null) {
            return this.childPolicy.newQueryPlan(keyspace, statement);
        }
        final Set<Host> replicas = this.clusterMetadata.getReplicas(Metadata.quote(keyspace), partitionKey);
        if (replicas.isEmpty()) {
            return this.childPolicy.newQueryPlan(loggedKeyspace, statement);
        }
        if (this.shuffleReplicas) {
            ArrayList<Host> l = Lists.newArrayList(replicas);
            Collections.shuffle(l);
            iter = l.iterator();
        } else {
            iter = replicas.iterator();
        }
        return new AbstractIterator<Host>(){
            private Iterator<Host> childIterator;

            @Override
            protected Host computeNext() {
                Host host;
                while (iter.hasNext()) {
                    host = (Host)iter.next();
                    if (!host.isUp() || TokenAwarePolicy.this.childPolicy.distance(host) != HostDistance.LOCAL) continue;
                    return host;
                }
                if (this.childIterator == null) {
                    this.childIterator = TokenAwarePolicy.this.childPolicy.newQueryPlan(loggedKeyspace, statement);
                }
                while (this.childIterator.hasNext()) {
                    host = this.childIterator.next();
                    if (replicas.contains(host) && TokenAwarePolicy.this.childPolicy.distance(host) == HostDistance.LOCAL) continue;
                    return host;
                }
                return (Host)this.endOfData();
            }
        };
    }

    @Override
    public void onUp(Host host) {
        this.childPolicy.onUp(host);
    }

    @Override
    public void onDown(Host host) {
        this.childPolicy.onDown(host);
    }

    @Override
    public void onAdd(Host host) {
        this.childPolicy.onAdd(host);
    }

    @Override
    public void onRemove(Host host) {
        this.childPolicy.onRemove(host);
    }

    @Override
    public void close() {
        this.childPolicy.close();
    }
}

