/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.mongodb;

import com.d0x7.utils.config.ConfigUtils;
import com.d0x7.utils.database.Database;
import com.d0x7.utils.mongodb.MongoDBConfiguration;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;

public class MongoDB {
    private static MongoClient mongoClient;
    private static MongoDatabase database;
    private static boolean initialized;

    public static ListenableFuture<Boolean> setup() {
        if (ConfigUtils.get(MongoDBConfiguration.class) == null) {
            try {
                ConfigUtils.loadConfigurationFile(new File(System.getProperty("user.home"), "mongodb.database.json"), MongoDBConfiguration.class);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return Futures.immediateFailedFuture(e);
            }
        }
        return MongoDB.setup(ConfigUtils.get(MongoDBConfiguration.class));
    }

    public static ListenableFuture<Boolean> setup(MongoDBConfiguration mongoDBConfiguration) {
        if (initialized) {
            return Futures.immediateFuture(true);
        }
        initialized = true;
        return Database.getExecutorService().submit(() -> {
            MongoDB.disableLogger();
            mongoClient = mongoDBConfiguration.getUsername() == null || mongoDBConfiguration.getUsername().isEmpty() || mongoDBConfiguration.getPassword() == null || mongoDBConfiguration.getPassword().isEmpty() ? new MongoClient(mongoDBConfiguration.getServerAddresses(), MongoClientOptions.builder().serverSelectionTimeout(3000).connectTimeout(3000).build()) : new MongoClient(mongoDBConfiguration.getServerAddresses(), Lists.newArrayList(MongoCredential.createCredential(mongoDBConfiguration.getUsername(), mongoDBConfiguration.getDatabase(), mongoDBConfiguration.getPassword().toCharArray())), MongoClientOptions.builder().serverSelectionTimeout(3000).connectTimeout(3000).build());
            MongoDB.disableLogger();
            database = mongoClient.getDatabase(mongoDBConfiguration.getDatabase());
            return database.runCommand(new BasicDBObject("ping", (Object)1)) != null;
        });
    }

    public static void shutdown() {
        mongoClient.close();
    }

    public static boolean isConnected() {
        return database.runCommand(new BasicDBObject("ping", (Object)1)) != null;
    }

    public static void disableLogger() {
        MongoDB.setLoggerLevel(Level.OFF);
    }

    public static void setLoggerLevel(Level level) {
        Logger.getLogger("org.mongodb.driver.connection").setLevel(level);
        Logger.getLogger("org.mongodb.driver.management").setLevel(level);
        Logger.getLogger("org.mongodb.driver.cluster").setLevel(level);
        Logger.getLogger("org.mongodb.driver.protocol.insert").setLevel(level);
        Logger.getLogger("org.mongodb.driver.protocol.query").setLevel(level);
        Logger.getLogger("org.mongodb.driver.protocol.update").setLevel(level);
    }

    public static Level getLoggerLevel() {
        return Logger.getLogger("org.mongodb.driver.connection").getLevel();
    }

    public static int getNextSequence(String name) {
        return MongoDB.getDatabase().getCollection("counters").findOneAndUpdate(new Document("_id", name), new Document("$inc", new Document("seq", 1)), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER)).getInteger("seq");
    }

    public static MongoClient getMongoClient() {
        return mongoClient;
    }

    public static MongoDatabase getDatabase() {
        return database;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        initialized = false;
    }
}

