/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.examples.redis;

import com.d0x7.utils.database.Repository;
import com.d0x7.utils.examples.redis.ExampleRedisRepository;
import com.d0x7.utils.redis.Redis;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import redis.clients.jedis.Jedis;

public class RedisExample {
    public static void main(String[] args) {
        Futures.addCallback(Redis.setup(), new FutureCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean success) {
                if (!success.booleanValue()) {
                    throw new RuntimeException("Failed to connect to Redis");
                }
                ExampleRedisRepository repo = new ExampleRedisRepository();
                Futures.addCallback(repo.getSomething(), new FutureCallback<String>(){

                    @Override
                    public void onSuccess(String value) {
                        if (value != null) {
                            System.out.println("We found a awesome value!");
                            System.out.println(value);
                        } else {
                            System.out.println("We couldn't find a value! :(");
                        }
                    }

                    @Override
                    public void onFailure(Throwable throwable) {
                        throwable.printStackTrace();
                        System.out.println("ffs, something dumb happened!");
                    }
                });
                Repository.getRepository(ExampleRedisRepository.class);
                try (Jedis jedis = Redis.get();){
                    System.out.println(jedis.get("some_key"));
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                throwable.printStackTrace();
                System.exit(1);
            }
        });
    }
}

