/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.examples.mysql;

import com.d0x7.utils.database.Repository;
import com.d0x7.utils.examples.mysql.ExampleMySQLRepository;
import com.d0x7.utils.mysql.MySQL;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MySQLExample {
    public static void main(String[] args) {
        Futures.addCallback(MySQL.setup(), new FutureCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean success) {
                if (!success.booleanValue()) {
                    throw new RuntimeException("Failed to connect to MySQL");
                }
                ExampleMySQLRepository repo = new ExampleMySQLRepository();
                Futures.addCallback(repo.querySomething(), new FutureCallback<ResultSet>(){

                    @Override
                    public void onSuccess(ResultSet resultSet) {
                        if (resultSet != null) {
                            System.out.println("We found a awesome ResultSet!");
                            System.out.println(resultSet);
                        } else {
                            System.out.println("We couldn't find a ResultSet! :(");
                        }
                    }

                    @Override
                    public void onFailure(Throwable throwable) {
                        throwable.printStackTrace();
                        System.out.println("ffs, something dumb happened!");
                    }
                });
                Repository.getRepository(ExampleMySQLRepository.class);
                try {
                    ResultSet resultSet = MySQL.getConnection().prepareStatement("SELECT * FROM some_awesome_table").executeQuery();
                    if (resultSet != null) {
                        System.out.println("We found a awesome ResultSet!");
                        System.out.println(resultSet);
                    } else {
                        System.out.println("We couldn't find a ResultSet! :(");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                throwable.printStackTrace();
                System.exit(1);
            }
        });
    }
}

