/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.examples.cassandra;

import com.d0x7.utils.cassandra.Cassandra;
import com.d0x7.utils.database.Repository;
import com.d0x7.utils.examples.cassandra.ExampleCassandraRepository;
import com.datastax.driver.core.ResultSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;

public class CassandraExample {
    public static void main(String[] args) {
        Futures.addCallback(Cassandra.setup(), new FutureCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean success) {
                if (!success.booleanValue()) {
                    throw new RuntimeException("Failed to connect to Cassandra");
                }
                ExampleCassandraRepository repo = new ExampleCassandraRepository();
                Futures.addCallback(repo.querySomething(), new FutureCallback<ResultSet>(){

                    @Override
                    public void onSuccess(ResultSet resultSet) {
                        if (resultSet != null) {
                            System.out.println("We found a awesome ResultSet!");
                            System.out.println(resultSet);
                        } else {
                            System.out.println("We couldn't find a ResultSet! :(");
                        }
                    }

                    @Override
                    public void onFailure(Throwable throwable) {
                        throwable.printStackTrace();
                        System.out.println("ffs, something dumb happened!");
                    }
                });
                Repository.getRepository(ExampleCassandraRepository.class);
                ResultSet resultSet = Cassandra.getSession("some_keyspace").execute("SELECT * FROM some_awesome_table");
                if (resultSet != null) {
                    System.out.println("We found a awesome ResultSet!");
                    System.out.println(resultSet);
                } else {
                    System.out.println("We couldn't find a ResultSet! :(");
                }
                repo.printAllTables();
            }

            @Override
            public void onFailure(Throwable throwable) {
                throwable.printStackTrace();
                System.exit(1);
            }
        });
    }
}

