/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.config;

import com.d0x7.utils.config.Config;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;

public class ConfigUtils {
    private static Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
    private static Map<Class<? extends Config>, Config> singleInstanceConfigs = Maps.newHashMap();

    public static <T extends Config> T loadConfigurationFile(File file, Class<T> clazz) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException {
        return ConfigUtils.loadConfigurationFile(file, clazz, true);
    }

    public static <T extends Config> T loadConfigurationFile(File file, Class<T> clazz, boolean createFromDefaults) throws NoSuchMethodException, IOException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Config config;
        Preconditions.checkState(file.exists() || createFromDefaults, "Configuration File must already exists or createFromDefaults must be used");
        if (!file.exists()) {
            config = (Config)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            config.createDefaults();
            Files.write(file.toPath(), ConfigUtils.getPrettyGson().toJson(config).getBytes(Charsets.UTF_8), new OpenOption[0]);
        } else {
            config = (Config)ConfigUtils.getPrettyGson().fromJson(new String(Files.readAllBytes(file.toPath()), Charsets.UTF_8), clazz);
        }
        config.postProcess();
        if (config.isSingleInstance()) {
            singleInstanceConfigs.put(clazz, config);
        }
        return (T)config;
    }

    public static <T> T get(Class<? extends T> clazz) {
        return (T)singleInstanceConfigs.get(clazz);
    }

    public static Gson getPrettyGson() {
        return prettyGson;
    }
}

