/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.cassandra;

import com.d0x7.utils.cassandra.CassandraConfiguration;
import com.d0x7.utils.config.ConfigUtils;
import com.d0x7.utils.database.Database;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class Cassandra {
    private static Cluster cluster;
    private static Map<String, Session> sessions;
    private static Map<String, KeyspaceMetadata> keyspaceMetadatas;
    private static boolean initialized;

    public static ListenableFuture<Boolean> setup() {
        if (ConfigUtils.get(CassandraConfiguration.class) == null) {
            try {
                ConfigUtils.loadConfigurationFile(new File(System.getProperty("user.home"), "cassandra.database.json"), CassandraConfiguration.class);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return Futures.immediateFailedFuture(e);
            }
        }
        return Cassandra.setup(ConfigUtils.get(CassandraConfiguration.class));
    }

    public static ListenableFuture<Boolean> setup(CassandraConfiguration cassandraConfiguration) {
        if (initialized) {
            return Futures.immediateFuture(true);
        }
        sessions = Maps.newHashMap();
        keyspaceMetadatas = Maps.newHashMap();
        Cluster.Builder builder = new Cluster.Builder();
        cassandraConfiguration.getContactPoints().forEach(builder::addContactPoint);
        cluster = builder.build();
        SettableFuture<Boolean> future = SettableFuture.create();
        for (String keyspaceName : cassandraConfiguration.getKeyspaces()) {
            Database.getExecutorService().submit(() -> {
                Session session = cluster.connect();
                KeyspaceMetadata keyspaceMetadata = cluster.getMetadata().getKeyspace(keyspaceName);
                if (keyspaceMetadata == null) {
                    String datacenter = cluster.getMetadata().getAllHosts().iterator().next().getDatacenter();
                    session.execute(String.format("CREATE KEYSPACE IF NOT EXISTS %s WITH REPLICATION = {'class': 'NetworkTopologyStrategy', '%s': 3};", keyspaceName, datacenter));
                    keyspaceMetadata = cluster.getMetadata().getKeyspace(keyspaceName);
                }
                session.execute("USE " + keyspaceName);
                sessions.put(keyspaceName, session);
                keyspaceMetadatas.put(keyspaceName, keyspaceMetadata);
                if (sessions.size() == cassandraConfiguration.getKeyspaces().size()) {
                    future.set(true);
                }
            });
        }
        initialized = true;
        return future;
    }

    public static Session getSession(String keyspace) {
        return sessions.get(keyspace);
    }

    public static KeyspaceMetadata getKeyspaceMetadata(String keyspace) {
        return keyspaceMetadatas.get(keyspace);
    }

    public static void shutdown() {
        sessions.values().forEach(Session::close);
        sessions.clear();
        keyspaceMetadatas.clear();
        cluster.close();
    }

    public static boolean isConnected() {
        return !cluster.isClosed();
    }

    public static Cluster getCluster() {
        return cluster;
    }

    public static Map<String, Session> getSessions() {
        return sessions;
    }

    public static Map<String, KeyspaceMetadata> getKeyspaceMetadatas() {
        return keyspaceMetadatas;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        initialized = false;
    }
}

