package com.d0x7.utils.examples.mongodb;

import com.d0x7.utils.database.Repository;
import com.d0x7.utils.mongodb.MongoDB;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import org.bson.Document;

/**
 * Copyright (c) 2015-2017 d0x7.com
 * <p>
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * <p>
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * <p>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
public class MongoDBExample {

    public static void main(String[] args) {
        // The connection settings for mongodb are by default loaded from ~/mongodb.database.json e.g. /home/dorian/mongodb.database.json
        Futures.addCallback(MongoDB.setup(), new FutureCallback<Boolean>() {
            @Override
            public void onSuccess(Boolean success) {
                if (!success)
                    throw new RuntimeException("Failed to connect to MongoDB");

                // We are already in a asynchronous thread but yeah, whatever.

                // Example using a MongoDBRepository
                ExampleMongoRepository repo = new ExampleMongoRepository();

                Futures.addCallback(repo.findSomething(), new FutureCallback<Document>() {
                    @Override
                    public void onSuccess(Document document) {
                        if (document != null) {
                            System.out.println("We found a awesome document!");
                            System.out.println(document);
                        } else
                            System.out.println("We couldn't find a document! :(");
                    }

                    @Override
                    public void onFailure(Throwable throwable) {
                        throwable.printStackTrace();
                        System.out.println("ffs, something dumb happened!");
                    }
                });

                // The repository can also be, like the singleton configs, retrieved at any time using
                Repository.getRepository(ExampleMongoRepository.class);


                // Example without a MongoDBRepository

                Document document = MongoDB.getDatabase().getCollection("my_awesome_collection").find().first();

                if (document != null) {
                    System.out.println("We found a awesome document!");
                    System.out.println(document);
                } else
                    System.out.println("We couldn't find a document! :(");
            }

            @Override
            public void onFailure(Throwable throwable) {
                throwable.printStackTrace();
                System.exit(1);
            }
        });

    }
}
