/*
 * Decompiled with CFR 0.152.
 */
package com.cxense.cxensesdk;

import android.content.ContentValues;
import com.cxense.cxensesdk.CxenseConfiguration;
import com.cxense.cxensesdk.EventConverter;
import com.cxense.cxensesdk.PageViewEventConverter;
import com.cxense.cxensesdk.db.DatabaseHelper;
import com.cxense.cxensesdk.db.EventRecord;
import com.cxense.cxensesdk.model.Event;
import com.cxense.cxensesdk.model.EventStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007J?\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u0013J\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0011J\u0016\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\rJ\u001b\u0010#\u001a\u00020!2\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0\u0015\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\u0004\u0018\u00010\u0011*\u00020\b2\u0006\u0010(\u001a\u00020%H\u0002J\f\u0010)\u001a\u00020\u0011*\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/cxense/cxensesdk/EventRepository;", "", "configuration", "Lcom/cxense/cxensesdk/CxenseConfiguration;", "databaseHelper", "Lcom/cxense/cxensesdk/db/DatabaseHelper;", "eventConverters", "", "Lcom/cxense/cxensesdk/EventConverter;", "(Lcom/cxense/cxensesdk/CxenseConfiguration;Lcom/cxense/cxensesdk/db/DatabaseHelper;Ljava/util/List;)V", "deleteOutdatedEvents", "", "outdatePeriod", "", "getEventStatuses", "Lcom/cxense/cxensesdk/model/EventStatus;", "getEvents", "Lcom/cxense/cxensesdk/db/EventRecord;", "selection", "", "selectionArgs", "", "limit", "getEvents$sdk_release", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Ljava/util/List;", "getNotSubmittedConversionEvents", "getNotSubmittedDmpEvents", "getNotSubmittedPvEvents", "getPvEventFromDatabase", "eventId", "putEventRecordInDatabase", "eventRecord", "putEventTime", "", "activeTime", "putEventsInDatabase", "events", "Lcom/cxense/cxensesdk/model/Event;", "([Lcom/cxense/cxensesdk/model/Event;)V", "buildEventRecord", "e", "toEventRecord", "Landroid/content/ContentValues;", "Companion", "sdk_release"})
public final class EventRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CxenseConfiguration configuration;
    @NotNull
    private final DatabaseHelper databaseHelper;
    @NotNull
    private final List<EventConverter> eventConverters;
    @NotNull
    private static final String NOT_SENT_FILTER = "isSent = 0";

    public EventRepository(@NotNull CxenseConfiguration configuration, @NotNull DatabaseHelper databaseHelper2, @NotNull List<? extends EventConverter> eventConverters) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)databaseHelper2), (String)"databaseHelper");
        Intrinsics.checkNotNullParameter(eventConverters, (String)"eventConverters");
        this.configuration = configuration;
        this.databaseHelper = databaseHelper2;
        this.eventConverters = eventConverters;
    }

    public final void putEventsInDatabase(@NotNull Event[] events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Event[] $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        Event[] eventArray = $this$forEach$iv;
        int n = eventArray.length;
        for (int i = 0; i < n; ++i) {
            Event element$iv;
            Event e = element$iv = eventArray[i];
            boolean bl = false;
            try {
                EventRecord eventRecord;
                Object v0;
                Object it;
                block4: {
                    Iterable $this$firstOrNull$iv = this.eventConverters;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        it = (EventConverter)element$iv2;
                        boolean bl2 = false;
                        if (!((EventConverter)it).canConvert(e)) continue;
                        v0 = element$iv2;
                        break block4;
                    }
                    v0 = null;
                }
                EventConverter eventConverter = v0;
                if (eventConverter == null || (eventRecord = this.buildEventRecord(eventConverter, e)) == null) continue;
                EventRecord eventRecord2 = eventRecord;
                boolean bl3 = false;
                boolean bl4 = false;
                it = eventRecord2;
                boolean bl5 = false;
                this.putEventRecordInDatabase((EventRecord)it);
                continue;
            }
            catch (Exception ex) {
                Timber.Forest.e((Throwable)ex, "Error at pushing event", new Object[0]);
            }
        }
    }

    public final long putEventRecordInDatabase(@NotNull EventRecord eventRecord) {
        Intrinsics.checkNotNullParameter((Object)eventRecord, (String)"eventRecord");
        return this.databaseHelper.save(eventRecord);
    }

    public final int deleteOutdatedEvents(long outdatePeriod) {
        String[] stringArray = new String[]{String.valueOf(System.currentTimeMillis() - outdatePeriod)};
        return this.databaseHelper.delete("time < ?", stringArray);
    }

    @NotNull
    public final List<EventRecord> getNotSubmittedPvEvents() {
        String[] stringArray = new String[]{"pgv"};
        return EventRepository.getEvents$sdk_release$default(this, "isSent = 0 AND type = ?", stringArray, null, 4, null);
    }

    @NotNull
    public final List<EventRecord> getNotSubmittedDmpEvents() {
        String[] stringArray = new String[]{"pgv", "conversion"};
        return EventRepository.getEvents$sdk_release$default(this, "isSent = 0 AND type <> ? AND type <> ?", stringArray, null, 4, null);
    }

    @NotNull
    public final List<EventRecord> getNotSubmittedConversionEvents() {
        String[] stringArray = new String[]{"conversion"};
        return EventRepository.getEvents$sdk_release$default(this, "isSent = 0 AND type = ?", stringArray, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EventRecord> getEvents$sdk_release(@Nullable String selection, @Nullable String[] selectionArgs, @Nullable String limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = DatabaseHelper.query$default(this.databaseHelper, null, selection, selectionArgs, null, null, "time ASC", limit, 25, null);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ContentValues contentValues = (ContentValues)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EventRecord eventRecord = this.toEventRecord((ContentValues)it);
            collection.add(eventRecord);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getEvents$sdk_release$default(EventRepository eventRepository2, String string, String[] stringArray, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return eventRepository2.getEvents$sdk_release(string, stringArray, string2);
    }

    @Nullable
    public final EventRecord getPvEventFromDatabase(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        String[] stringArray = new String[]{eventId, "pgv"};
        ContentValues contentValues = (ContentValues)CollectionsKt.firstOrNull((List)DatabaseHelper.query$default(this.databaseHelper, null, "customId = ? AND type = ?", stringArray, null, null, "time DESC", "1", 25, null));
        return contentValues == null ? null : this.toEventRecord(contentValues);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EventStatus> getEventStatuses() {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"customId", "isSent"};
        Iterable $this$map$iv = DatabaseHelper.query$default(this.databaseHelper, stringArray, null, null, null, null, "time ASC", null, 94, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ContentValues contentValues = (ContentValues)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAsString("customId");
            Boolean bl2 = it.getAsBoolean("isSent");
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"it.getAsBoolean(EventRecord.IS_SENT)");
            EventStatus eventStatus = new EventStatus(string, bl2, null, 4, null);
            collection.add(eventStatus);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void putEventTime(@NotNull String eventId, long activeTime) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        try {
            void $this$mapNotNullTo$iv$iv;
            EventRecord eventRecord = this.getPvEventFromDatabase(eventId);
            if (eventRecord == null) {
                return;
            }
            EventRecord record = eventRecord;
            Object object = activeTime;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)object).longValue();
            boolean bl3 = false;
            Object object2 = it > 0L ? object : null;
            long time = object2 == null ? TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - record.getTimestamp()) : ((Long)object2).longValue();
            Iterable $this$mapNotNull$iv = this.eventConverters;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PageViewEventConverter pageViewEventConverter2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                EventConverter it2 = (EventConverter)element$iv$iv;
                boolean bl5 = false;
                if ((it2 instanceof PageViewEventConverter ? (PageViewEventConverter)it2 : null) == null) continue;
                pageViewEventConverter2 = pageViewEventConverter2;
                boolean bl6 = false;
                boolean bl7 = false;
                PageViewEventConverter it$iv$iv = pageViewEventConverter2;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object2 = (PageViewEventConverter)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (object2 != null) {
                object = object2;
                bl = false;
                boolean bl9 = false;
                Object $this$putEventTime_u24lambda_u2d7 = object;
                boolean bl10 = false;
                this.putEventRecordInDatabase(EventRecord.copy$default(record, null, null, ((PageViewEventConverter)$this$putEventTime_u24lambda_u2d7).updateActiveTimeData$sdk_release(record.getData(), time), null, null, 0L, time, 0, null, false, 955, null));
            }
        }
        catch (Exception e) {
            Timber.Forest.e((Throwable)e, "Error at tracking time", new Object[0]);
        }
    }

    private final EventRecord buildEventRecord(EventConverter $this$buildEventRecord, Event e) {
        EventRecord eventRecord;
        Object object = new String[]{String.valueOf(e.getMergeKey()), String.valueOf(System.currentTimeMillis() - this.configuration.getEventsMergePeriod())};
        EventRecord eventRecord2 = (EventRecord)CollectionsKt.firstOrNull(this.getEvents$sdk_release("isSent = 0 AND mergeKey = ? AND time > ?", (String[])object, "1"));
        if (eventRecord2 == null) {
            eventRecord = null;
        } else {
            object = eventRecord2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            eventRecord = $this$buildEventRecord.update((EventRecord)it, e);
        }
        EventRecord eventRecord3 = eventRecord;
        return eventRecord3 == null ? $this$buildEventRecord.toEventRecord(e) : eventRecord3;
    }

    private final EventRecord toEventRecord(ContentValues $this$toEventRecord) {
        Object object = $this$toEventRecord.getAsString("type");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getAsString(EventRecord.TYPE)");
        String string = object;
        String string2 = $this$toEventRecord.getAsString("customId");
        object = $this$toEventRecord.getAsString("event");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getAsString(EventRecord.DATA)");
        String string3 = object;
        String string4 = $this$toEventRecord.getAsString("ckp");
        String string5 = $this$toEventRecord.getAsString("rnd");
        object = $this$toEventRecord.getAsLong("time");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getAsLong(EventRecord.TIME)");
        long l = ((Number)object).longValue();
        Long l2 = $this$toEventRecord.getAsLong("spentTime");
        object = $this$toEventRecord.getAsInteger("mergeKey");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getAsInteger(EventRecord.MERGE_KEY)");
        int n = ((Number)object).intValue();
        Long l3 = $this$toEventRecord.getAsLong("_id");
        object = $this$toEventRecord.getAsBoolean("isSent");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getAsBoolean(EventRecord.IS_SENT)");
        return new EventRecord(string, string2, string3, string4, string5, l, l2, n, l3, (Boolean)object);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cxense/cxensesdk/EventRepository$Companion;", "", "()V", "NOT_SENT_FILTER", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

